<?php

use betawall\components\NavManager;
use betawall\db\models\SettingsModel;
use betawall\helpers\BinaryHelper;
use betawall\helpers\MainHelper;
use betawall\helpers\MuHelper;

$navManager = new NavManager();

$activeTab = (isset($_GET['c'], $_GET['a'])) ? $_GET['c'].'_'.$_GET['a'] : 'home_index';

$muHelper = new MuHelper();
$muPluginStatus = $muHelper->isEnabledMuPluginMode();

$mainHelper = new MainHelper();
$lastDatabaseUpdate = $mainHelper->getDateTimeLastDatabaseUpdate();
$currentProtectionInfo = $mainHelper->getCurrentProtectionInfo();

$settingsModel = new SettingsModel();
$generalScanRedDotShowed = $settingsModel->get_by_name($settingsModel->general_scan_red_dot)->value_number ?? 0;
$generalScanRedDot = '';
if ((current_time('timestamp') - $generalScanRedDotShowed) >= SettingsModel::GENERAL_SCAN_RED_DOT_SHOW_INTERVAL) {
    $generalScanRedDot = '🔴';
}
$bwS = BinaryHelper::getInstance()->searchInPermanentList(BinaryHelper::S) !== false;

?>

<div class="wrap">
    <div class="bw-header">
        <div class="bw-logo"></div>
        <?php if ($bwS): ?>
            <span class="bw-plus">PRO</span>
        <?php endif; ?>
        <a href="<?= MainHelper::getSupportLink() ?>" target="_blank" class="bw-support bw-black"><?= __('Support', BW_PLUGIN_SLUG) ?></a>
    </div>
    <div class="bw-current-version"><?= __('Current version: ', BW_PLUGIN_SLUG) ?><b><?= BW_PLUGIN_VERSION ?></b></div>


    <?php if (!defined('BW_PLUGIN_UNBLOCK_PAGE')) : ?>


    <div class="bw-main-statuses">
        <div class="bw-main-status bw-protection-status">
            <div class="bw-status-ic <?= esc_attr($currentProtectionInfo['protection_status_icon']) ?>"></div>
            <div class="bw-status-text bw-black"><?= esc_html($currentProtectionInfo['protection_status_title']) ?></div>
            <?php if ($currentProtectionInfo['link_settings']['needed']): ?>
                <a href="<?= $currentProtectionInfo['link_settings']['link'] ?>" class="bw-status-button button-primary"><?= $currentProtectionInfo['link_settings']['text'] ?></a>
            <?php endif; ?>
            <?php if ($currentProtectionInfo['button_enable']['needed']): ?>
                <button class="bw-status-button button-primary bw-firewall-protection-enable"><?= $currentProtectionInfo['button_enable']['text'] ?></button>
            <?php endif; ?>
        </div>

        <div class="bw-main-status bw-mu-status">
            <div class="bw-status-ic <?php if ($muPluginStatus) { echo 'enabled-ic'; } else { echo 'disabled-ic'; } ?>"></div>
            <div class="bw-status-text bw-black">
                <?= __('MU Plugin', BW_PLUGIN_SLUG) ?>
                <?php if ($muPluginStatus): ?>
                    <?= __('enabled', BW_PLUGIN_SLUG) ?>
                <?php else: ?>
                    <?= __('disabled', BW_PLUGIN_SLUG) ?>
                <?php endif; ?>
            </div>
            <div class="bw-tooltip-icon" data-tooltip="<?= __('An MU Plugin in WordPress loads earlier than all other plugins, allowing the security system to begin working at the earliest stages of request processing. This enables blocking malicious requests, validating API keys, or filtering traffic before the main site code is executed, providing an additional layer of security.', BW_PLUGIN_SLUG) ?>"></div>
            <?php if (!$muPluginStatus): ?>
                <button class="bw-status-button button-primary bw-mu-plugin-enable"><?= __('Enable', BW_PLUGIN_SLUG) ?></button>
            <?php endif; ?>
        </div>
    </div>

    <div class="nav-tab-wrapper bw-nav-tab-wrapper">
        <?php
            echo '<a href="' . esc_url($navManager->generate_url('home', 'index')). '" class="nav-tab ' . ($activeTab == 'home_index' ? 'nav-tab-active' : '') . '">' . __('Dashboard', BW_PLUGIN_SLUG) . '</a>';
            echo '<a href="' . esc_url($navManager->generate_url('general_scan', 'index')). '" class="nav-tab ' . ($activeTab == 'general_scan_index' ? 'nav-tab-active' : '') . '">' . __('General scan', BW_PLUGIN_SLUG) . ' ' . $generalScanRedDot . '</a>';
            echo '<a href="' . esc_url($navManager->generate_url('firewall', 'index')). '" class="nav-tab ' . ($activeTab == 'firewall_index' ? 'nav-tab-active' : '') . '">' . __('Firewall', BW_PLUGIN_SLUG) . '</a>';
            echo '<a href="' . esc_url($navManager->generate_url('firewall', 'settings')). '" class="nav-tab ' . ($activeTab == 'firewall_settings' ? 'nav-tab-active' : '') . '">' . __('Settings', BW_PLUGIN_SLUG) . '</a>';
        ?>
        <div class="bw-last-db-update-info">
            <div class="bw-last-db-update-info-title bw-gray"><?= __('Last database update', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-last-db-update-info-date bw-gray"><?= esc_html($lastDatabaseUpdate) ?></div>
            <div class="bw-get-db-update-container">
                <div class="bw-spinner spinner bw-db-update-indicator"></div>
                <button class="bw-get-db-update-button button active"><?= __('Update now', BW_PLUGIN_SLUG) ?></button>
            </div>
        </div>
    </div>


    <?php endif; ?>


    <?= $content ?? '' ?>
</div>
<script>
    let bw_s = <?= json_encode($bwS) ?>;
    let bw_js_texts = {
        'bw_confirm_delete_readme': '<?= __('Are you sure you want to delete readme.html?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_license': '<?= __('Are you sure you want to delete license.txt?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_debug_log': '<?= __('Are you sure you want to enable WP_DEBUG_LOG?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_debug_log': '<?= __('Are you sure you want to disable WP_DEBUG_LOG?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_debug_file': '<?= __('Are you sure you want to delete debug.log?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_rest_api': '<?= __('Are you sure you want to enable the REST API?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_rest_api': '<?= __('Are you sure you want to disable the REST API?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_xml_rpc': '<?= __('Are you sure you want to enable XML-RPC?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_xml_rpc': '<?= __('Are you sure you want to disable XML-RPC?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_rss': '<?= __('Are you sure you want to enable RSS?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_rss': '<?= __('Are you sure you want to disable RSS?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_unused_theme': '<?= __('Are you sure you want to delete this theme?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_unused_plugin': '<?= __('Are you sure you want to delete this plugin?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_move_ip_to_whitelist': '<?= __('Are you sure you want to whitelist this IP address?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_ip_from_blacklist': '<?= __('Are you sure you want to delete this IP address from the blocked list?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_delete_ip_from_whitelist': '<?= __('Are you sure you want to delete this IP address from the whitelist?', BW_PLUGIN_SLUG) ?>',
        'bw_ip_address_is_blank': '<?= __('IP Address is blank', BW_PLUGIN_SLUG) ?>',
        'bw_ip_address_is_not_valid': '<?= __('Invalid IP Address', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_mu_plugin': '<?= __('Are you sure you want to enable the MU Plugin?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_mu_plugin': '<?= __('Are you sure you want to disable the MU Plugin?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_all_protection': '<?= __('Are you sure you want to enable protection?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_all_protection': '<?= __('Are you sure you want to disable all protection?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_reset_defaults_protection': '<?= __('Are you sure you want to reset default settings?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_save_protection_settings': '<?= __('Confirm saving changes', BW_PLUGIN_SLUG) ?>',
        'bw_error_message_firewall_settings': '<?= __('Invalid data', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_enable_allowed_ips': '<?= __('Are you sure you want to enable Allowed IPs?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_disable_allowed_ips': '<?= __('Are you sure you want to disable Allowed IPs?', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_save_recaptcha_settings': '<?= __('Are you sure you want to save reCAPTCHA settings?', BW_PLUGIN_SLUG) ?>',
        'bw_alert_empty_recaptcha_fields': '<?= __('Site Key and Secret Key can`t be empty', BW_PLUGIN_SLUG) ?>',
        'bw_alert_wrong_recaptcha_site_key': '<?= __('The GOOGLE reCAPTCHA v3 Site Key is invalid', BW_PLUGIN_SLUG) ?>',
        'bw_alert_wrong_recaptcha_secret_key': '<?= __('The GOOGLE reCAPTCHA v3 Secret Key is invalid', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_save_g2fa_settings' : '<?= __('Are you sure you want to save changes for users?', BW_PLUGIN_SLUG) ?>',
        'bw_2fa_pagination_users' : '<?= __('users', BW_PLUGIN_SLUG) ?>',
        'bw_2fa_pagination_from' : '<?= __('from', BW_PLUGIN_SLUG) ?>',
        'bw_no_unused_plugins_or_themes' : '<?= __('Not found', BW_PLUGIN_SLUG) ?>',
        'bw_confirm_change_2fa_users_select': '<?= __('Are you sure? All unsaved changes will be lost', BW_PLUGIN_SLUG) ?>',
        'bw_2fa_enabled': '<?= __('2FA enabled', BW_PLUGIN_SLUG) ?>',
        'bw_2fa_disabled': '<?= __('2FA disabled', BW_PLUGIN_SLUG) ?>',
        'bw_animation_save_button_text': '<?= __('Saved', BW_PLUGIN_SLUG) ?>',
        'bw_text_more_info': '<?= __('More Info', BW_PLUGIN_SLUG) ?>',
        'bw_text_less_info': '<?= __('Less Info', BW_PLUGIN_SLUG) ?>',
        'bw_text_not_found': '<?= __('Not found', BW_PLUGIN_SLUG) ?>',
        'bw_text_ok': '<?= __('Ok', BW_PLUGIN_SLUG) ?>',
        'bw_text_fail': '<?= __('Fail', BW_PLUGIN_SLUG) ?>',
        'bw_text_disable': '<?= __('Disable', BW_PLUGIN_SLUG) ?>',
        'bw_text_disabled': '<?= __('Disabled', BW_PLUGIN_SLUG) ?>',
        'bw_text_enable': '<?= __('Enable', BW_PLUGIN_SLUG) ?>',
        'bw_text_enabled': '<?= __('Enabled', BW_PLUGIN_SLUG) ?>',
        'bw_click_to_view_details': '<?= __('Click to view details', BW_PLUGIN_SLUG) ?>',
        'bw_click_to_hide_details': '<?= __('Click to hide details', BW_PLUGIN_SLUG) ?>',
    };
</script>
