<?php

use betawall\crud\FirewallBlacklistTableData;
use betawall\db\models\MalwareModel;

?>
<div class="tab-content bw-tab-content">
    <div class="bw-home-stat-title bw-black"><?= __('In the previous 30 days we repelled', BW_PLUGIN_SLUG) ?></div>
    <div class="bw-home-all-counts bw-black"><span><?= esc_html($all_attacks_30d_count) ?? 0 ?></span> <?= __('attacks', BW_PLUGIN_SLUG) ?></div>
    <div class="bw-home-blocks">
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_NOT_FOUND, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-404">
            <div class="bw-home-block-item-title bw-black"><?= __('404 Request Flood', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($notfound_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_LOGIN, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-admin-panel">
            <div class="bw-home-block-item-title bw-black"><?= __('Admin Panel Brute Force', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($admin_panel_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_SQL_INJECTION, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-injection">
            <div class="bw-home-block-item-title bw-black"><?= __('SQL Injection Attacks', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($sql_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_CODE_EXECUTION, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-code-execution">
            <div class="bw-home-block-item-title bw-black"><?= __('Arbitrary Code Execution', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($code_execution_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_XSS, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-xss">
            <div class="bw-home-block-item-title bw-black"><?= __('XSS Attacks', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($xss_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_RFI, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-rfi">
            <div class="bw-home-block-item-title bw-black"><?= __('RFI Attacks', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($rfi_attacks_30d_count) ?? 0 ?></div>
        </a>
        <a href="<?= esc_url($nav_manager->generate_url('firewall', 'index', ['filter_request_type' => MalwareModel::TYPE_SUSPICIOUS_FILE, 'filter_date_range' => FirewallBlacklistTableData::FILTER_DATE_RANGE_30D])) ?>" class="bw-home-block-item bw-home-block-files">
            <div class="bw-home-block-item-title bw-black"><?= __('Suspicious File Uploads', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-home-block-item-count bw-black"><?= esc_html($suspicious_files_attacks_30d_count) ?? 0 ?></div>
        </a>
    </div>
</div>