<?php
/** @var \betawall\components\NavManager $navManager */
/** @var array $hidden_users */
/** @var array $hidden_user_creators */
/** @var array $hooks_for_hidden_users */
/** @var array $hidden_plugins */
/** @var bool $ssl_status */
/** @var array $readme_and_license */
/** @var array $debug_log */
/** @var bool $rest_api_status */
/** @var array $rest_api_external_usage */
/** @var bool $xml_rpc_status */
/** @var array $xml_rpc_external_usage */
/** @var bool $rss_status */
/** @var array $rss_external_usage */
/** @var array $unused_themes */
/** @var array $unused_plugins */
?>

<div class="bw-quick-fix-wrapper">
    <div class="bw-quick-fix-block bw-quick-fix-header">
        <?= __('Betawall Security Scan: Quick Fixes', BW_PLUGIN_SLUG) ?>
    </div>
    <div class="bw-quick-fix-block bw-quick-fix-footer bw-gray">
        <?= __("A simplified overview of your website's security status. Address critical issues with ease to strengthen your defenses", BW_PLUGIN_SLUG) ?>
    </div>

    <!-- Quick Fix Block: Hidden Admin Accounts -->
    <div class="bw-quick-fix-block js-bw-hidden-users-block">
        <div class="bw-qf-header">
            <?php if ($hidden_users): ?>
                <div class="bw-qf-title js-bw-hidden-users-title bw-fail">
                    <span class="bw-icon-admin-alert js-bw-hidden-users-icon bw-qf-icon"></span>
                    <?= __('Hidden Admin Accounts', BW_PLUGIN_SLUG) ?>
                </div>
                <div class="bw-qf-status-wrap">
                    <div class="bw-general-scan-settings-value-item js-bw-hidden-users-value red red2"><?= __('Fail', BW_PLUGIN_SLUG) ?></div>
                    <button type="button" class="bw-qf-toggle">
                        <?= __('More Info', BW_PLUGIN_SLUG) ?> <span class="bw-icon-arrow"></span>
                    </button>
                </div>
            <?php else: ?>
                <div class="bw-qf-title js-bw-hidden-users-title bw-ok">
                    <span class="bw-icon-admin js-bw-hidden-users-icon bw-qf-icon"></span>
                    <?= __('Hidden Admin Accounts', BW_PLUGIN_SLUG) ?>
                </div>
                <div class="bw-qf-status-wrap">
                    <div class="bw-general-scan-settings-value-item js-bw-hidden-users-value green"><?= __('Ok', BW_PLUGIN_SLUG) ?></div>
                    <button type="button" class="bw-qf-toggle">
                        <?= __('More Info', BW_PLUGIN_SLUG) ?> <span class="bw-icon-arrow"></span>
                    </button>
                </div>
            <?php endif; ?>
        </div>


        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right js-bw-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('Detects if any administrator accounts are not visible or easily discoverable, which could indicate a security risk. Malicious actors sometimes create hidden admin accounts to maintain access to your site unnoticed.', BW_PLUGIN_SLUG) ?>
                </p>
                <?php if ($hidden_users): ?>
                    <ul class="bw-qf-list js-bw-hidden-users-list">
                        <?php foreach ($hidden_users as $hidden_user): ?>
                            <li class="js-bw-hidden-user-id-<?= $hidden_user['ID'] ?>">
                                <div class="bw-qf-list-item-content">
                                    <strong><?= __('User', BW_PLUGIN_SLUG) ?>:</strong> <?= $hidden_user['user_login'] ?>
                                    (ID: <?= $hidden_user['ID'] ?>)<br>
                                    <small>
                                        <?= __('Account created on', BW_PLUGIN_SLUG) ?> <?= $hidden_user['user_registered'] ?>.
                                        <?= __('Last login', BW_PLUGIN_SLUG) ?>: <?= $hidden_user['last_login'] ?>.
                                    </small>
                                </div>
                                <button class="button button-red js-delete-hidden-user"
                                        data-user-id="<?= $hidden_user['ID'] ?>"
                                        data-user-login="<?= $hidden_user['user_login'] ?>"
                                        data-user-email="<?= $hidden_user['user_email'] ?>"
                                        data-user-display-name="<?= $hidden_user['display_name'] ?>"

                                        data-creator-file-type="<?= $hidden_user['creator']['file_type'] ?? '' ?>"
                                        data-creator-file="<?= $hidden_user['creator']['file'] ?? '' ?>"
                                        data-creator-method="<?= $hidden_user['creator']['method'] ?? '' ?>"

                                        data-hook-file-type="<?= $hidden_user['hook']['file_type'] ?? '' ?>"
                                        data-hook-file="<?= $hidden_user['hook']['file'] ?? '' ?>"
                                        data-hook-method="<?= $hidden_user['hook']['method'] ?? '' ?>"

                                >
                                    <?= __('Delete Account', BW_PLUGIN_SLUG) ?>
                                </button>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="bw-black">
                        <?= __('Not found', BW_PLUGIN_SLUG) ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: Hidden Plugins -->
    <div class="bw-quick-fix-block js-bw-hidden-plugins-block">
        <div class="bw-qf-header">
            <?php if ($hidden_plugins): ?>
                <div class="bw-qf-title js-bw-hidden-plugins-title bw-fail">
                    <span class="bw-icon-plugin-alert js-bw-hidden-plugins-icon bw-qf-icon"></span>
                    <?= __('Hidden Plugins', BW_PLUGIN_SLUG) ?>
                </div>
                <div class="bw-qf-status-wrap">
                    <div class="bw-general-scan-settings-value-item js-bw-hidden-plugins-value red red2">
                        <?= __('Fail', BW_PLUGIN_SLUG) ?>
                    </div>
                    <button type="button" class="bw-qf-toggle">
                        <?= __('More Info', BW_PLUGIN_SLUG) ?>
                        <span class="bw-icon-arrow"></span>
                    </button>
                </div>
            <?php else: ?>
                <div class="bw-qf-title js-bw-hidden-plugins-title bw-ok">
                    <span class="bw-icon-plugin js-bw-hidden-plugins-icon bw-qf-icon"></span>
                    <?= __('Hidden Plugins', BW_PLUGIN_SLUG) ?>
                </div>
                <div class="bw-qf-status-wrap">
                    <div class="bw-general-scan-settings-value-item js-bw-hidden-plugins-value green">
                        <?= __('Ok', BW_PLUGIN_SLUG) ?>
                    </div>
                    <button type="button" class="bw-qf-toggle">
                        <?= __('More Info', BW_PLUGIN_SLUG) ?>
                        <span class="bw-icon-arrow"></span>
                    </button>
                </div>
            <?php endif; ?>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right js-bw-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('Identifies plugins that are not readily visible in your WordPress dashboard, potentially indicating malicious or hidden software. While some plugins may intentionally hide system features, unknown plugins can pose a security risk.', BW_PLUGIN_SLUG) ?>
                </p>
                <?php if ($hidden_plugins): ?>
                    <ul class="bw-qf-list">
                        <?php foreach ($hidden_plugins as $hidden_plugin): ?>
                            <li class="js-bw-hidden-plugin-<?= $hidden_plugin['TextDomain'] ?>">
                                <div class="bw-qf-list-item-content">
                                    <strong><?= $hidden_plugin['Name'] ?></strong><br>
                                    <small>
                                        <?= __('Path', BW_PLUGIN_SLUG) ?>:
                                        <?= $hidden_plugin['mu_plugin_path'] ?: $hidden_plugin['plugin_path'] ?><br>
                                        <?= __('Last Modified', BW_PLUGIN_SLUG) ?>:
                                        <?= $hidden_plugin['modify'] ?>
                                    </small>
                                </div>
                                <div class="bw-qf-actions">
                                    <?php if ($hidden_plugin['Author'] || $hidden_plugin['TextDomain'] || $hidden_plugin['Version']): ?>
                                        <button class="button button-red js-delete-hidden-plugin"
                                                data-file="<?= $hidden_plugin['plugin_path'] ?>"
                                                data-textdomain="<?= $hidden_plugin['TextDomain'] ?>"
                                                data-source="<?= $hidden_plugin['plugin_path'] ?>"
                                                data-source-path="<?= $hidden_plugin['mu_plugin_path'] ?: $hidden_plugin['plugin_path'] ?>"
                                                data-name="<?= $hidden_plugin['Name'] ?>"
                                                data-method="<?= $hidden_plugin['hits'][0]['method'] ?? 'unknown' ?>"
                                        >
                                            <?= __('Deactivate & Delete', BW_PLUGIN_SLUG) ?>
                                        </button>
                                    <?php else:; ?>
                                        <div class="bw-general-scan-settings-value-item js-bw-rest-api-value bw-warning bw-padding-right-10"><?= __('Risk of plugin hiding via autonomous MU plugin', BW_PLUGIN_SLUG) ?></div>
                                    <?php endif; ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="bw-black">
                        <?= __('Not found', BW_PLUGIN_SLUG) ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block (SSL) -->
    <div class="bw-quick-fix-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title <?= $ssl_status ? 'bw-ok' : 'bw-fail' ?>">
                <span class="bw-icon-ssl<?= $ssl_status ? '' : '-alert' ?> bw-qf-icon"></span>
                SSL (Secure Sockets Layer)
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item <?= $ssl_status ? 'green' : 'red red2' ?>"><?= __($ssl_status ? 'Ok' : 'Fail', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('The security protocol that ensures a secure connection between a web server and a user’s browser. SSL encrypts data transmitted over the internet, such as passwords, personal information, and payment details, protecting it from being intercepted by attackers.', BW_PLUGIN_SLUG) ?>
                </p>
                <ul class="bw-qf-list">
                    <li>
                        <div class="bw-qf-list-item-content">
                            SSL
                        </div>
                        <div class="bw-general-scan-settings-value-item <?= $ssl_status ? 'green' : 'red red1' ?>">
                            <?= __($ssl_status ? 'Ok' : 'Fail', BW_PLUGIN_SLUG) ?>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: README AND LICENSE -->
    <div class="bw-quick-fix-block js-bw-readme-and-license-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-r-a-l-title <?= $readme_and_license['readme'] || $readme_and_license['license'] ? 'bw-fail' : 'bw-ok' ?>">
                <span class="bw-icon-doc<?= $readme_and_license['readme'] || $readme_and_license['license'] ? '-alert' : '' ?> bw-qf-icon js-bw-r-a-l-icon"></span>
                README AND LICENSE
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-r-a-l-value
                    <?= $readme_and_license['readme'] || $readme_and_license['license'] ? 'red red2' : 'green' ?>"
                >
                    <?= $readme_and_license['readme'] || $readme_and_license['license'] ? __('Fail', BW_PLUGIN_SLUG) : __('Ok', BW_PLUGIN_SLUG) ?>
                </div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('The files readme.html and license.txt in WordPress contain information about a plugin or theme and its license. readme.html provides a description, installation instructions, and developer details, while license.txt explains the terms of use. These files are important for transparency and compliance with the license. However, they can be removed from production sites to enhance security by hiding technical details from outsiders.', BW_PLUGIN_SLUG) ?>
                </p>
                <ul class="bw-qf-files-list">
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name">readme.html</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $readme_and_license['readme'] ? 'red red1' : 'green' ?>"><?= __($readme_and_license['readme'] ? 'Found' : 'Not found', BW_PLUGIN_SLUG) ?></div>
                            <?= $readme_and_license['readme'] ? ('<button class="button button-red js-bw-general-delete-readme">' . __('Delete', BW_PLUGIN_SLUG) . '</button>') : '' ?>
                        </div>
                    </li>
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name">license.txt</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $readme_and_license['license'] ? 'red red1' : 'green' ?>"><?= __($readme_and_license['license'] ? 'Found' : 'Not found', BW_PLUGIN_SLUG) ?></div>
                            <?= $readme_and_license['license'] ? ('<button class="button button-red js-bw-general-delete-license">' . __('Delete', BW_PLUGIN_SLUG) . '</button>') : '' ?>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: DEBUG LOG -->
    <div class="bw-quick-fix-block js-bw-debug-log-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-debug-log-title <?= $debug_log['is_enabled'] || $debug_log['exists_debug_file'] ? 'bw-fail' : 'bw-ok' ?>">
                <span class="bw-icon-log<?= $debug_log['is_enabled'] || $debug_log['exists_debug_file'] ? '-alert' : '' ?> bw-qf-icon js-bw-debug-log-icon"></span>
                DEBUG LOG
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-debug-log-value <?= $debug_log['is_enabled'] || $debug_log['exists_debug_file'] ? 'red red2' : 'green' ?>"><?= $debug_log['is_enabled'] || $debug_log['exists_debug_file'] ? __('Fail', BW_PLUGIN_SLUG) : __('Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('This mode is used in WordPress to log errors and warnings to the debug.log file located in the wp-content folder. The mode allows developers to track errors without displaying them on the screen.', BW_PLUGIN_SLUG) ?>
                </p>
                <ul class="bw-qf-files-list">
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name"><?= __('Mode', BW_PLUGIN_SLUG) ?></div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $debug_log['is_enabled'] ? 'red red1' : 'green' ?>"><?= __($debug_log['is_enabled'] ? 'Enabled' : 'Disabled', BW_PLUGIN_SLUG) ?></div>
                            <?= $debug_log['is_enabled'] ?
                                ('<button class="js-bw-general-disable-debug-log button button-primary">' . __('Disable', BW_PLUGIN_SLUG) . '</button>')
                                :
                                ('<button class="js-bw-general-enable-debug-log button button-red">' . __('Enable', BW_PLUGIN_SLUG) . '</button>')
                            ?>
                        </div>
                    </li>
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name"><?= __('File', BW_PLUGIN_SLUG) ?> debug.log</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $debug_log['exists_debug_file'] ? 'red red2' : 'green' ?>"><?= __($debug_log['exists_debug_file'] ? 'Found' : 'Not found', BW_PLUGIN_SLUG) ?></div>
                            <?= $debug_log['exists_debug_file'] ? ('<button class="button button-red js-bw-general-delete-debug-file">' . __('Delete', BW_PLUGIN_SLUG) . '</button>') : '' ?>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: REST API -->
    <div class="bw-quick-fix-block js-bw-rest-api-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-rest-api-title <?= $rest_api_external_usage ? 'bw-warning' : ($rest_api_status ? 'bw-fail' : 'bw-ok') ?>">
                <span class="bw-icon-rest-api<?= $rest_api_external_usage ? '-warning' : ($rest_api_status ? '-alert' : '') ?> bw-qf-icon js-bw-rest-api-icon"></span>
                REST API
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-rest-api-value <?= $rest_api_external_usage ? 'bw-warning' : ($rest_api_status ? 'red red2' : 'green') ?>"><?= __($rest_api_status ? 'Fail' : 'Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('An interface that allows external applications to interact with the site. It provides access to WordPress data and functionality through HTTP requests, supporting the creation, reading, updating, and deletion of data.', BW_PLUGIN_SLUG) ?>
                </p>

                <ul class="bw-qf-files-list">
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name">REST API</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $rest_api_status ? 'red red1' : 'green' ?>"><?= __($rest_api_status ? 'Enabled' : 'Disabled', BW_PLUGIN_SLUG) ?></div>
                            <?= $rest_api_status ?
                                '<button class="button button-primary js-bw-general-disable-rest-api">' . __('Disable', BW_PLUGIN_SLUG) . '</button>'
                                :
                                '<button class="button button-red js-bw-general-enable-rest-api">' . __('Enable', BW_PLUGIN_SLUG) . '</button>'
                            ?>
                        </div>
                    </li>
                </ul>
                <?php if ($rest_api_external_usage): ?>
                    <p class="bw-gray bw-qf-desc bw-qf-desc-big-margin">
                        <span class="bw-icon-warning bw-vertical-align-sub bw-qf-icon"></span>
                        <?= __('Plugins on your website that are currently use REST API:', BW_PLUGIN_SLUG) ?>
                    </p>
                    <ul class="bw-qf-files-list-row js-bw-external-usage-plugins">
                        <?php foreach ($rest_api_external_usage as $plugin): ?>
                            <li>
                                <div class="bw-qf-file-block-row">
                                    <div class="bw-qf-file-name"><?= $plugin ?></div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: XML-RPC -->
    <div class="bw-quick-fix-block js-bw-xml-rpc-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-xml-rpc-title <?= $xml_rpc_external_usage ? 'bw-warning' : ($xml_rpc_status ? 'bw-fail' : 'bw-ok') ?>">
                <span class="bw-icon-xmlrpc<?= $xml_rpc_external_usage ? '-warning' : ($xml_rpc_status ? '-alert' : '') ?> js-bw-xml-rpc-icon bw-qf-icon"></span>
                XML-RPC
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-xml-rpc-value <?= $xml_rpc_external_usage ? 'bw-warning' : ($xml_rpc_status ? 'red red2' : 'green') ?>"><?= __($xml_rpc_status ? 'Fail' : 'Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('XML-RPC (XML Remote Procedure Call) is a remote procedure call protocol that allows applications to interact with WordPress remotely. XML-RPC uses XML to encode data and HTTP as a transport protocol to provide remote access to a WordPress site.', BW_PLUGIN_SLUG) ?>
                </p>
                <p class="bw-gray bw-qf-desc">
                    <?= __("XML-RPC can be vulnerable to attacks such as password brute force or DDoS, as it provides remote access to the site. Many websites disable XML-RPC if they don't require this functionality to enhance security.", BW_PLUGIN_SLUG) ?>
                </p>
                <ul class="bw-qf-files-list">
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name">XML-RPC</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $xml_rpc_status ? 'red red1' : 'green' ?>"><?= __($xml_rpc_status ? 'Enabled' : 'Disabled', BW_PLUGIN_SLUG) ?></div>
                            <?= $xml_rpc_status ?
                                ('<button class="button button-primary js-bw-general-disable-xml-rpc">' . __('Disable', BW_PLUGIN_SLUG) . '</button>')
                                :
                                ('<button class="button button-red js-bw-general-enable-xml-rpc">' . __('Enable', BW_PLUGIN_SLUG) . '</button>')
                            ?>
                        </div>
                    </li>
                </ul>
                <?php if ($xml_rpc_external_usage): ?>
                    <p class="bw-gray bw-qf-desc bw-qf-desc-big-margin">
                        <span class="bw-icon-warning bw-vertical-align-sub bw-qf-icon"></span>
                        <?= __('Plugins on your website that are currently use XML-RPC:', BW_PLUGIN_SLUG) ?>
                    </p>
                    <ul class="bw-qf-files-list-row js-bw-external-usage-plugins">
                        <?php foreach ($xml_rpc_external_usage as $plugin): ?>
                            <li>
                                <div class="bw-qf-file-block-row">
                                    <div class="bw-qf-file-name"><?= $plugin ?></div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: RSS (Really Simple Syndication) -->
    <div class="bw-quick-fix-block js-bw-rss-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-rss-title <?= $rss_external_usage ? 'bw-warning' : ($rss_status ? 'bw-fail' : 'bw-ok') ?>">
                <span class="bw-icon-rss<?= $rss_external_usage ? '-warning' : ($rss_status ? '-alert' : '') ?> js-bw-rss-icon bw-qf-icon"></span>
                RSS (Really Simple Syndication)
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-rss-value <?= $rss_external_usage ? 'bw-warning' : ($rss_status ? 'red red2' : 'green') ?>"><?= __($rss_status ? 'Fail' : 'Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('The format for automatic receipt has been updated from the site. In WordPress, RSS feeds allow users and applications to receive new articles, pages, or comments in the form of a stream that updates automatically. This is convenient for subscribing to content and integration with external services. RSS feeds can be configured or disabled if they are not required for the site.', BW_PLUGIN_SLUG) ?>
                </p>
                <ul class="bw-qf-files-list">
                    <li>
                        <div class="bw-qf-file-block">
                            <div class="bw-qf-file-name">RSS</div>
                        </div>
                        <div class="bw-qf-file-status">
                            <div class="bw-general-scan-settings-value-item <?= $rss_status ? 'red red1' : 'green' ?>"><?= __($rss_status ? 'Enabled' : 'Disabled', BW_PLUGIN_SLUG) ?></div>
                            <?= $rss_status ?
                                ('<button class="button button-primary js-bw-general-disable-rss">' . __('Disable', BW_PLUGIN_SLUG) . '</button>')
                                :
                                ('<button class="button button-red js-bw-general-enable-rss">' . __('Enable', BW_PLUGIN_SLUG) . '</button>')
                            ?>
                        </div>
                    </li>
                </ul>
                <?php if ($rss_external_usage): ?>
                    <p class="bw-gray bw-qf-desc bw-qf-desc-big-margin">
                        <span class="bw-icon-warning bw-vertical-align-sub bw-qf-icon"></span>
                        <?= __('Plugins on your website that are currently use RSS:', BW_PLUGIN_SLUG) ?>
                    </p>
                    <ul class="bw-qf-files-list-row js-bw-external-usage-plugins">
                        <?php foreach ($rss_external_usage as $plugin): ?>
                            <li>
                                <div class="bw-qf-file-block-row">
                                    <div class="bw-qf-file-name"><?= $plugin ?></div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>

            </div>
        </div>
    </div>


    <!-- Quick Fix Block: UNUSED THEMES -->
    <div class="bw-quick-fix-block js-bw-unused-themes-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-unused-themes-title <?= $unused_themes ? 'bw-fail' : 'bw-ok' ?>">
                <span class="bw-icon-theme<?= $unused_themes ? '-alert' : '' ?> js-bw-unused-themes-icon bw-qf-icon"></span>
                <?= __('UNUSED THEMES', BW_PLUGIN_SLUG) ?>
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-unused-themes-value <?= $unused_themes ? 'red red2' : 'green' ?>"><?= __($unused_themes ? 'Fail' : 'Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right js-bw-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('Themes on your website that are currently not in use.', BW_PLUGIN_SLUG) ?>
                </p>
                <?php if ($unused_themes): ?>
                    <ul class="bw-qf-files-list">
                        <?php foreach ($unused_themes as $unused_theme => $unused_theme_title): ?>
                            <li>
                                <div class="bw-qf-file-block">
                                    <div class="bw-qf-file-name"><?= $unused_theme_title ?></div>
                                </div>
                                <div class="bw-qf-file-status">
                                    <button class="button button-red js-bw-delete-theme" data-slug="<?= $unused_theme ?>"><?= __('Delete', BW_PLUGIN_SLUG) ?></button>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="bw-black">
                        <?= __('Not found', BW_PLUGIN_SLUG) ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Quick Fix Block: UNUSED PLUGINS -->
    <div class="bw-quick-fix-block js-bw-unused-plugins-block">
        <div class="bw-qf-header">
            <div class="bw-qf-title js-bw-unused-plugins-title <?= $unused_plugins ? 'bw-fail' : 'bw-ok' ?>">
                <span class="bw-icon-plugin-generic<?= $unused_plugins ? '-alert' : '' ?> js-bw-unused-plugins-icon bw-qf-icon"></span>
                <?= __('UNUSED PLUGINS', BW_PLUGIN_SLUG) ?>
            </div>
            <div class="bw-qf-status-wrap">
                <div class="bw-general-scan-settings-value-item js-bw-unused-plugins-value <?= $unused_plugins ? 'red red2' : 'green' ?>"><?= __($unused_plugins ? 'Fail' : 'Ok', BW_PLUGIN_SLUG) ?></div>
                <button type="button" class="bw-qf-toggle">
                    <?= __('More Info', BW_PLUGIN_SLUG) ?>
                    <span class="bw-icon-arrow"></span>
                </button>
            </div>
        </div>

        <div class="bw-qf-body">
            <div class="bw-qf-body-left"></div>
            <div class="bw-qf-body-right js-bw-body-right">
                <p class="bw-gray bw-qf-desc">
                    <?= __('Plugins on your website that are currently not in use.', BW_PLUGIN_SLUG) ?>
                </p>
                <?php if ($unused_plugins): ?>
                    <ul class="bw-qf-files-list">
                        <?php foreach ($unused_plugins as $unused_plugin => $unused_plugin_title): ?>
                            <li>
                                <div class="bw-qf-file-block">
                                    <div class="bw-qf-file-name"><?= $unused_plugin_title ?></div>
                                </div>
                                <div class="bw-qf-file-status">
                                    <button class="button button-red js-bw-delete-plugin" data-plugin="<?= $unused_plugin ?>"><?= __('Delete', BW_PLUGIN_SLUG) ?></button>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="bw-black">
                        <?= __('Not found', BW_PLUGIN_SLUG) ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
