<?php

use betawall\db\models\SettingsModel;

$settingsModel = new SettingsModel();

?>
<div class="tab-content bw-tab-content">
    <div class="bw-home-stat-title bw-black"><?= __('Threat Monitoring Settings', BW_PLUGIN_SLUG) ?></div>

    <div class="bw-firewall-settings-container bw-container-max-w-900 bw-container-margin-b-10">
        <div class="bw-firewall-settings-headers">
            <div class="bw-firewall-settings-header-name bw-gray">
                <?= __('Attack Vectors', BW_PLUGIN_SLUG) ?>
            </div>
            <div class="bw-firewall-settings-header-values bw-gray">
                <?= __('Queries', BW_PLUGIN_SLUG) ?>
            </div>
        </div>

        <?php if (!empty($firewall_all_settings)): ?>
            <div class="bw-firewall-settings-wrap">
                <?php foreach ($firewall_all_settings as $module): ?>
                    <div class="bw-firewall-settings-module-item">
                        <div class="bw-firewall-settings-module-name">
                            <label>
                                <input type="checkbox" class="bw-firewall-settings-module-checkbox" id="bw-<?= esc_attr($module['module_id']) ?>-enabled" value="on" <?php checked(($module['is_enabled'] == 1 ? 'on' : 'off'), 'on'); ?>>
                                <?= esc_html($module['module_name']) ?>
                            </label>
                            <div class="bw-tooltip-icon" data-tooltip="<?= $module['module_info'] ?>"></div>
                            <?php if (isset($module['submodules']) && !empty($module['submodules'])): ?>
                                <?php foreach ($module['submodules'] as $submodule): ?>
                                    <div class="bw-firewall-settings-sub-module<?php echo ($module['is_enabled'] == 1) ? ' bw-item-active' : '' ?>">
                                        <label>
                                            <input type="checkbox" class="bw-firewall-settings-sub-module-checkbox" id="bw-<?= esc_attr($submodule['module_id']) ?>-enabled" value="on" <?php checked(($submodule['is_enabled'] == 1 ? 'on' : 'off'), 'on'); ?>>
                                            <?= esc_html($submodule['module_name']) ?>
                                        </label>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <div class="bw-firewall-settings-module-values-wrap">
                            <?php if (isset($module['5m_limit'])): ?>
                                <div class="bw-firewall-settings-module-value-group">
                                    <label for="bw-<?= esc_attr($module['module_id']) ?>-5m-input" class="bw-firewall-settings-module-value-label <?php if ($module['is_enabled'] != 1) echo 'bw-gray'; ?>">
                                        <?= __('5 minutes', BW_PLUGIN_SLUG) ?>
                                    </label>
                                    <div class="bw-firewall-settings-module-value-input">
                                        <input type="text" class="js-bw-<?= esc_attr($module['5m_limit_class']) ?>" id="bw-<?= esc_attr($module['module_id']) ?>-5m-input" value="<?= esc_attr($module['5m_limit']) ?>" <?php if ($module['is_enabled'] != 1) echo 'disabled="disabled"'; ?>>
                                        <div class="bw-action-error-message"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if (isset($module['24h_limit'])): ?>
                                <div class="bw-firewall-settings-module-value-group">
                                    <label for="bw-<?= esc_attr($module['module_id']) ?>-24h-input" class="bw-firewall-settings-module-value-label <?php if ($module['is_enabled'] != 1) echo 'bw-gray'; ?>">
                                        <?= __('24 hours', BW_PLUGIN_SLUG) ?>
                                    </label>
                                    <div class="bw-firewall-settings-module-value-input">
                                        <input type="text" class="js-bw-<?= esc_attr($module['24h_limit_class']) ?>" id="bw-<?= esc_attr($module['module_id']) ?>-24h-input" value="<?= esc_attr($module['24h_limit']) ?>" <?php if ($module['is_enabled'] != 1) echo 'disabled="disabled"'; ?>>
                                        <div class="bw-action-error-message"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if (!empty($firewall_all_settings)): ?>
        <div class="bw-firewall-settings-buttons-wrap bw-container-max-w-900">
            <div class="bw-firewall-settings-buttons-group">
                <button class="button button-red js-bw-firewall-disable-all"><?= __('Disable all', BW_PLUGIN_SLUG) ?></button>
            </div>
            <div class="bw-firewall-settings-buttons-group">
                <button class="button button js-bw-firewall-reset-defaults"><?= __('Reset defaults', BW_PLUGIN_SLUG) ?></button>
                <button class="button button-primary js-bw-firewall-save"><?= __('Save', BW_PLUGIN_SLUG) ?></button>
            </div>
        </div>
    <?php endif; ?>

    <?php if (isset($is_enabled_mu_plugin)): ?>
        <div class="bw-general-scan-module-container bw-container-max-w-900">
            <div class="bw-general-scan-module-title bw-black"><?= __('MU Plugin', BW_PLUGIN_SLUG) ?></div>
            <p class="bw-general-scan-module-description bw-gray">
                <?= __('An MU Plugin in WordPress loads earlier than all other plugins, allowing the security system to begin working at the earliest stages of request processing. This enables blocking malicious requests, validating API keys, or filtering traffic before the main site code is executed, providing an additional layer of security.', BW_PLUGIN_SLUG) ?>
            </p>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('MU Plugin', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <?php if ($is_enabled_mu_plugin): ?>
                            <div class="bw-general-scan-settings-value-item green"><?= __('Enabled', BW_PLUGIN_SLUG) ?></div>
                            <button class="bw-settings-mu-plugin-disable button button-red"><?= __('Disable', BW_PLUGIN_SLUG) ?></button>
                        <?php else: ?>
                            <div class="bw-general-scan-settings-value-item red red1"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>
                            <button class="bw-settings-mu-plugin-enable button-primary"><?= __('Enable', BW_PLUGIN_SLUG) ?></button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <!-- start block: Multi-user 2FA -->
    <?php if ($g2fa !== null): ?>
        <div class="bw-firewall-settings-container bw-container-max-w-900 bw-container-margin-b-10">
            <div class="bw-general-scan-module-title bw-black"><?= __('Enable 2fa for all users', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-general-scan-module-settings-wrap js-bw-user2fa-list">
                <div class="bw-firewall-settings-module-name bw-firewall-width-inherit bw-justify-content">
                    <label>
                        <input class="bw-firewall-settings-module-checkbox js-bw-g2fa-global-state" type="checkbox" name="bw_g2fa_enabled" value="<?= esc_attr($g2fa) ?>"<?php echo esc_attr($g2fa ? ' checked="checked"' : ''); ?>/>
                        <?= __('If enabled, users with 2FA enabled will be required to enter a code when logging in', BW_PLUGIN_SLUG) ?>
                    </label>
                    <div class="bw-firewall-settings-buttons-group">
                        <button class="button button-primary js-bw-save-2fa-settings-button" style="display: none;"><?= __('Save', BW_PLUGIN_SLUG) ?></button>
                    </div>

                </div>
                <div class="bw-actions-container container bw-block-select-action js-bw-2fa-rows-with-data<?php echo esc_attr($g2fa ? '' : ' bw-state' ); ?>">
                    <?php echo $g2faRolesSelectHtmlBlock ?>
                </div>
                <?php echo $g2faUsersListHtmlBlock ?>
            </div>
        </div>
        <div class="bw-firewall-settings-buttons-wrap bw-container-max-w-900">
            <div class="bw-firewall-settings-buttons-group js-bw-2fa-users-pagination-block"></div>
        </div>
    <?php endif; ?>
    <!-- end block: Multi-user 2FA -->

    <!-- start block: Google reCAPTCHA -->
    <?php if ($recaptcha !== null): ?>
        <div class="bw-firewall-settings-container bw-container-max-w-900 bw-container-margin-b-10">
            <div class="bw-general-scan-module-title bw-black"><?= __('Google reCAPTCHA v3 Settings', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-firewall-settings-module-name bw-firewall-width-inherit">
                    <label>
                        <input class="bw-firewall-settings-module-checkbox js-bw-recaptcha" type="checkbox" name="bw_recaptcha_login_enabled" id="recaptcha_login_enabled" value="<?= esc_attr($recaptcha) ?>"<?php echo esc_attr($recaptcha ? ' checked="checked"' : ''); ?>/>
                        <?= __('Enable reCAPTCHA login protection', BW_PLUGIN_SLUG) ?>
                    </label>
                </div>
                <div class="bw-general-scan-module-settings-item without-status js-bw-recaptcha-site-key<?php echo esc_attr($recaptcha ? '' : ' bw-state' ); ?>">
                    <div class="bw-general-scan-settings-name-orig bw-firewall-width-25p">
                        <?= __('Site Key', BW_PLUGIN_SLUG) ?>
                    </div>
                    <div class="bw-general-scan-settings-name-orig bw-recaptcha-input-block bw-firewall-width-75p">
                        <input class="bw-firewall-width-66p" type="text" name="bw_recaptcha_login_site_key" value="<?php echo esc_attr($recaptcha_site_key); ?>" />
                    </div>
                </div>
                <div class="bw-general-scan-module-settings-item without-status js-bw-recaptcha-secret-key<?php echo esc_attr($recaptcha ? '' : ' bw-state' ); ?>">
                    <div class="bw-general-scan-settings-name-orig bw-firewall-width-25p">
                        <?= __('Secret Key', BW_PLUGIN_SLUG) ?>
                    </div>
                    <div class="bw-general-scan-settings-name-orig bw-recaptcha-input-block bw-firewall-width-75p">
                        <input class="bw-firewall-width-66p" type="text" name="bw_recaptcha_login_secret_key" value="<?php echo esc_attr($recaptcha_secret_key); ?>" />
                    </div>
                </div>
            </div>
        </div>
        <div class="bw-firewall-settings-buttons-wrap bw-container-max-w-900">
            <div class="bw-firewall-settings-buttons-group"></div>
            <div class="bw-firewall-settings-buttons-group">
                <button class="button button-primary js-bw-save-recaptcha-settings-button"><?= __('Save', BW_PLUGIN_SLUG) ?></button>
            </div>
        </div>
    <?php endif; ?>
    <!-- end block: Google reCAPTCHA -->

    <script>
        let default_settings_threat_monitor = '<?= $default_settings_threat_monitor ?>';
    </script>

</div>