<?php

use betawall\crud\FirewallBlacklistTableData;
use betawall\db\models\MalwareModel;

$selected_request_type = isset($_GET['filter_request_type']) ? sanitize_text_field($_GET['filter_request_type']) : '';
$selected_date_range = isset($_GET['filter_date_range']) ? sanitize_text_field($_GET['filter_date_range']) : '';
$current_search_request = isset($_GET['blacklist_search']) ? sanitize_text_field($_GET['blacklist_search']) : '';

?>
<div class="tab-content bw-tab-content">
    <?php if (isset($unblock_link)): ?>
        <div class="bw-general-scan-module-container">
            <div class="bw-general-scan-module-title bw-black"><?= __('Unblock link', BW_PLUGIN_SLUG) ?></div>
            <p class="bw-general-scan-module-description bw-gray">
                <?= __('The unblock link is a special mechanism that allows you to lift the restriction if your IP address has been blocked by the firewall. By following this link, your IP address will be automatically added to the whitelist, removing all restrictions. This provides a convenient way to restore access without the need for manual intervention in the site\'s and plugin\'s settings. It is recommended to save this link in a secure place to avoid potential issues when working with the site.', BW_PLUGIN_SLUG) ?>
            </p>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('Unblock link', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <div class="bw-general-scan-settings-value-item link">
                            <a href="<?= esc_attr($unblock_link) ?>" target="_blank"><?= esc_html($unblock_link) ?></a>
                            <div class="bw-blur-content bw-state bw-item-active"></div>
                        </div>
                        <button class="bw-show-unblock-link bw-state button-primary bw-item-active"><?= __('Show', BW_PLUGIN_SLUG) ?></button>
                        <button class="bw-hide-unblock-link bw-state button button-red"><?= __('Hide', BW_PLUGIN_SLUG) ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="bw-firewall-tables-horizontal-container">
        <div class="bw-firewall-table bw-firewall-table-65">
            <div class="bw-home-stat-title bw-black"><?= __('Blocked IP Addresses', BW_PLUGIN_SLUG) ?></div>

            <div class="bw-actions-container">
                <label for="bw-search-input" class="screen-reader-text"><?= __('Search by IP Address', BW_PLUGIN_SLUG); ?></label>
                <div class="bw-action-group">
                    <input class="bw-search-input" id="bw-search-input" type="text" placeholder="<?= __('Search by IP Address', BW_PLUGIN_SLUG) ?>" value="<?= $current_search_request ?>">
                    <div class="bw-action-error-message"></div>
                </div>
                <button class="button-primary bw-search-button"><?= __('Search', BW_PLUGIN_SLUG) ?></button>

                <label for="bw-filter-request-type" class="screen-reader-text"><?= __('Filter by Threat Type', BW_PLUGIN_SLUG); ?></label>
                <select name="filter_request_type" id="bw-filter-request-type" class="bw-filter-request-type">
                    <option value=""><?= __('All attacks', BW_PLUGIN_SLUG); ?></option>
                    <option value="<?= MalwareModel::TYPE_NOT_FOUND ?>" <?php selected($selected_request_type, MalwareModel::TYPE_NOT_FOUND); ?>><?= __('404 Request Flood', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_LOGIN ?>" <?php selected($selected_request_type, MalwareModel::TYPE_LOGIN); ?>><?= __('Admin Panel Brute Force', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_SQL_INJECTION ?>" <?php selected($selected_request_type, MalwareModel::TYPE_SQL_INJECTION); ?>><?= __('SQL Injection Attacks', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_CODE_EXECUTION ?>" <?php selected($selected_request_type, MalwareModel::TYPE_CODE_EXECUTION); ?>><?= __('Arbitrary Code Execution', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_XSS ?>" <?php selected($selected_request_type, MalwareModel::TYPE_XSS); ?>><?= __('XSS Attacks', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_RFI ?>" <?php selected($selected_request_type, MalwareModel::TYPE_RFI); ?>><?= __('RFI Attacks', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= MalwareModel::TYPE_SUSPICIOUS_FILE ?>" <?php selected($selected_request_type, MalwareModel::TYPE_SUSPICIOUS_FILE); ?>><?= __('Suspicious File Uploads', BW_PLUGIN_SLUG) ?></option>
                </select>

                <label for="bw-filter-date-range" class="screen-reader-text"><?= __('Filter by Date Range', BW_PLUGIN_SLUG); ?></label>
                <select name="filter_date_range" id="bw-filter-date-range" class="bw-filter-date-range">
                    <option value=""><?= __('All time', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= FirewallBlacklistTableData::FILTER_DATE_RANGE_5M ?>" <?php selected($selected_date_range, FirewallBlacklistTableData::FILTER_DATE_RANGE_5M); ?>><?= __('Last 5 minutes', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= FirewallBlacklistTableData::FILTER_DATE_RANGE_24H ?>" <?php selected($selected_date_range, FirewallBlacklistTableData::FILTER_DATE_RANGE_24H); ?>><?= __('Last 24 hours', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= FirewallBlacklistTableData::FILTER_DATE_RANGE_7D ?>" <?php selected($selected_date_range, FirewallBlacklistTableData::FILTER_DATE_RANGE_7D); ?>><?= __('Last 7 days', BW_PLUGIN_SLUG) ?></option>
                    <option value="<?= FirewallBlacklistTableData::FILTER_DATE_RANGE_30D ?>" <?php selected($selected_date_range, FirewallBlacklistTableData::FILTER_DATE_RANGE_30D); ?>><?= __('Last 30 days', BW_PLUGIN_SLUG) ?></option>
                </select>

                <button class="button bw-firewall-reset-filters"><?= __('Reset Filters', BW_PLUGIN_SLUG) ?></button>
            </div>
            <?php $firewall_blacklist_table_data->display(); ?>
        </div>

        <div class="bw-firewall-table bw-firewall-table-35">
            <div class="bw-home-stat-title bw-black"><?= __('Whitelist', BW_PLUGIN_SLUG) ?></div>

            <div class="bw-actions-container">
                <label for="bw-add-to-whitelist-input" class="screen-reader-text"><?= __('Add IP Address to whitelist', BW_PLUGIN_SLUG); ?></label>
                <div class="bw-action-group">
                    <input class="bw-add-to-whitelist-input" id="bw-add-to-whitelist-input" type="text" placeholder="<?= __('Add IP Address', BW_PLUGIN_SLUG) ?>">
                    <div class="bw-action-error-message"></div>
                </div>
                <button class="button-primary bw-add-to-whitelist-button"><?= __('Add', BW_PLUGIN_SLUG) ?></button>
            </div>
            <?php $firewall_whitelist_table_data->display(); ?>
        </div>
    </div>

    <?php if (isset($is_firewall_cache_synchronized)): ?>
        <div class="bw-general-scan-module-container" id="bw-firewall-cache">
            <div class="bw-general-scan-module-title bw-black"><?= __('Firewall cache', BW_PLUGIN_SLUG) ?></div>
            <p class="bw-general-scan-module-description bw-gray">
                <?= __('The Firewall cache is a mechanism designed to reduce the load on the database when frequent malicious requests are made to the site from blocked IP addresses. Instead of querying the database each time for verification, the system uses cached data, which significantly speeds up processing and reduces the load.<br><br>Cache synchronization ensures that data remains up to date by refreshing it when changes occur in the list of blocked IP addresses or whitelist addresses. This guarantees that the firewall effectively blocks threats and prevents them from repeatedly accessing the site while avoiding unnecessary database queries that could overload the server.', BW_PLUGIN_SLUG) ?>
            </p>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('Firewall cache', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <div class="bw-spinner spinner bw-settings-indicator"></div>
                        <?php if ($is_firewall_cache_synchronized): ?>
                            <div class="bw-general-scan-settings-value-item bw-state green bw-item-active"><?= __('Synchronized', BW_PLUGIN_SLUG) ?></div>
                        <?php else: ?>
                            <div class="bw-general-scan-settings-value-item bw-state red red1 bw-item-active"><?= __('Not synchronized', BW_PLUGIN_SLUG) ?></div>
                            <button class="bw-settings-cache-sync bw-state button-primary bw-item-active"><?= __('Synchronize', BW_PLUGIN_SLUG) ?></button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="bw-general-scan-module-container" id="bw-allowed-ips">
        <div class="bw-general-scan-module-title bw-black"><?= __('Allowed IPs* (Whitelist)', BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-description bw-gray"><?= __("How it works:", BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-description bw-gray"><?= __("* IP Allow List: The website administrator creates a list of IP addresses that are allowed to log in.", BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-description bw-gray"><?= __("* IP Check: When a user tries to log in, the website checks their IP address.", BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-description bw-gray"><?= __("* Access Granted: If the user's IP address is on the allow list, they are allowed to log in.", BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-description bw-gray"><?= __("* Access Denied: If the user's IP address is not on the allow list, they are denied access.", BW_PLUGIN_SLUG) ?></div>
        <div class="bw-general-scan-module-settings-wrap">
            <div class="bw-general-scan-module-settings-item">
                <div class="bw-general-scan-settings-name"><?= __('Allowed IPs', BW_PLUGIN_SLUG) ?></div>
                <div class="bw-general-scan-settings-value-wrap">
                    <div class="bw-spinner spinner bw-settings-indicator bw-item-active"></div>
                    <div class="bw-general-scan-settings-value-item bw-state bw-state-enabled green"><?= __('Enabled', BW_PLUGIN_SLUG) ?></div>
                    <button class="js-bw-allowed-ips-disable bw-state bw-state-enabled button button-red"><?= __('Disable', BW_PLUGIN_SLUG) ?></button>
                    <div class="bw-general-scan-settings-value-item bw-state bw-state-disabled red red1"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>
                    <button class="js-bw-allowed-ips-enable bw-state bw-state-disabled button-primary"><?= __('Enable', BW_PLUGIN_SLUG) ?></button>
                </div>
            </div>
        </div>
    </div>
</div>