<?php

use betawall\components\NavManager;
use betawall\db\models\SettingsModel;

if (!defined('BW_PLUGIN_UNBLOCK_PAGE')) {
    define('BW_PLUGIN_UNBLOCK_PAGE', true);
}

$unblockKey = sanitize_text_field(trim($_GET['key'] ?? ''));
$adminUrl = admin_url('admin-ajax.php');
$settingsModel = new SettingsModel();
$navManager = new NavManager();
$g2fa = $settingsModel->is2faEnabled();
$reCaptcha = $settingsModel->isReCaptchaEnabled();
$allowedIPs = $settingsModel->isAllowedIPsEnabled();

?>
<link rel="stylesheet" href="<?= WP_PLUGIN_URL ?>/betawall/assets/css/style.css?v=<?= BW_PLUGIN_VERSION ?>" media="all" />
<link rel="stylesheet" href="<?= WP_PLUGIN_URL ?>/betawall/assets/css/unblock.css?v=<?= BW_PLUGIN_VERSION ?>" media="all" />

<div class="wrap">
    <div class="centered-container">

        <div class="bw-general-scan-module-container">
            <div class="bw-general-scan-module-title bw-black"><?= __('2fa for all users', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('2fa', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <?php if ($g2fa): ?>
                            <div class="bw-general-scan-settings-value-item bw-state-enabled green"><?= __('Enabled', BW_PLUGIN_SLUG) ?></div>
                            <button class="js-bw-disable-button bw-state-enabled bw-disable-button button button-red" data-class="js-bw-g2fa"><?= __('Disable', BW_PLUGIN_SLUG) ?></button>
                        <?php else: ?>
                            <div class="bw-general-scan-settings-value-item bw-state bw-state-disabled red red1 bw-item-active"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="bw-general-scan-module-container">
            <div class="bw-general-scan-module-title bw-black"><?= __('Google reCAPTCHA v3 Settings', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('reCAPTCHA', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <?php if ($reCaptcha): ?>
                            <div class="bw-general-scan-settings-value-item bw-state-enabled green"><?= __('Enabled', BW_PLUGIN_SLUG) ?></div>
                            <button class="js-bw-disable-button bw-state-enabled bw-disable-button button button-red" data-class="js-bw-recaptcha"><?= __('Disable', BW_PLUGIN_SLUG) ?></button>
                        <?php else: ?>
                            <div class="bw-general-scan-settings-value-item bw-state bw-state-disabled red red1 bw-item-active"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="bw-general-scan-module-container">
            <div class="bw-general-scan-module-title bw-black"><?= __('Allowed IPs* (Whitelist)', BW_PLUGIN_SLUG) ?></div>
            <div class="bw-general-scan-module-settings-wrap">
                <div class="bw-general-scan-module-settings-item">
                    <div class="bw-general-scan-settings-name"><?= __('Allowed IPs', BW_PLUGIN_SLUG) ?></div>
                    <div class="bw-general-scan-settings-value-wrap">
                        <?php if ($allowedIPs): ?>
                            <div class="bw-general-scan-settings-value-item bw-state-enabled green"><?= __('Enabled', BW_PLUGIN_SLUG) ?></div>
                            <button class="js-bw-disable-button bw-state-enabled bw-disable-button button button-red" data-class="js-bw-allowed-ips"><?= __('Disable', BW_PLUGIN_SLUG) ?></button>
                        <?php else: ?>
                            <div class="bw-general-scan-settings-value-item bw-state bw-state-disabled red red1 bw-item-active"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <a class="bw-unblock-page-link" href="<?= esc_url($navManager->generate_url('firewall', 'settings')) ?>"><?= __('Go to Plugin Settings', BW_PLUGIN_SLUG) ?></a>
        <a class="bw-unblock-page-link" href="/"><?= __('Go to Main Page', BW_PLUGIN_SLUG) ?></a>
    </div>
</div>
<script src="<?= home_url() ?>/wp-admin/load-scripts.php?c=1&load[chunk_0]=jquery-core,jquery-migrate,utils&ver=6.8.1"></script>
<script src="<?= home_url() ?>/wp-includes/js/jquery/ui/core.min.js?ver=1.13.3"></script>
<script>
    let bw_class_to_rout = {
        'js-bw-g2fa': 'save_g2fa_changes',
        'js-bw-recaptcha': 'save_recapthca_settings',
        'js-bw-allowed-ips': 'change_allowed_ips_status',
    };
    let bw_class_to_parameter_name = {
        'js-bw-g2fa': 'g2fa_enabled',
        'js-bw-recaptcha': 'recaptcha',
        'js-bw-allowed-ips': 'enable',
    };

    let bw_feature_disabled_block = '<div class="bw-general-scan-settings-value-item bw-state bw-state-disabled red red1 bw-item-active"><?= __('Disabled', BW_PLUGIN_SLUG) ?></div>';

    jQuery(document).ready(function($) {
        $('.js-bw-disable-button').on('click', function () {
            let $this = $(this),
                $class = $this.data('class')
            ;
            $this.removeClass('button-red');
            sendAjaxRequest(
                'firewall',
                bw_class_to_rout[$class],
                {
                    unblock_key: '<?= $unblockKey ?>',
                    [bw_class_to_parameter_name[$class]]: 0,
                },
                function (response) {
                    if (response.result === 'successful') {
                        $this.parent().html(bw_feature_disabled_block);
                    }
                },
                function (xhr, status, error) {
                    // console.log('Response error: ', status, error);
                }
            );
        });
    });

    function sendAjaxRequest(controller, action, data, successCallback, errorCallback, method = 'POST') {jQuery.ajax({url: '<?= $adminUrl ?>', type: method, dataType: 'json', headers: {'HTTP_X_REQUESTED_WITH': 'XMLHttpRequest'}, data: {action: 'bw_action', c: controller, a: action, ...data}, success: function(response) {if (typeof successCallback === 'function') {successCallback(response);}}, error: function(xhr, status, error) {if (typeof errorCallback === 'function') {errorCallback(xhr, status, error);}}});}
</script>
