<?php /** @var $unblockLink */?>
<div class="bw-modal-overlay" id="activation-modal">
    <div class="bw-modal-container">
        <div class="bw-modal-middle">
            <div class="bw-modal-content">
                <div class="bw-logo"></div>
                <div class="bw-modal-close"></div>
                <div class="bw-modal-title bw-black"><?= __('Plugin activation', BW_PLUGIN_SLUG) ?></div>
                <div class="bw-modal-text">
                    <p><?= __('A unique secret link has been generated for you. <b>It may be required if the Firewall blocks your IP address</b>', BW_PLUGIN_SLUG) ?></p>
                    <p><?= __('After following the link, <b>your IP address will be added to the whitelist, and all restrictions on using the site will be lifted</b>', BW_PLUGIN_SLUG) ?></p>
                    <p><?= __('<b>Please save this link in a secure place</b>', BW_PLUGIN_SLUG) ?></p>
                </div>
                <div class="bw-modal-unblock-link-item">
                    <div class="bw-modal-copy-container">
                        <div class="bw-attention-icon"></div>
                        <input class="bw-copy-container-info" value="<?= $unblockLink ?>">
                        <button class="bw-modal-copy-btn"><?= __('Copy', BW_PLUGIN_SLUG) ?></button>
                    </div>
                </div>
                <div class="bw-modal-copied"><?= __('Copied', BW_PLUGIN_SLUG) ?></div>
                <p class="bw-modal-short-text"><?= __('Click <b>"Activate"</b> to continue', BW_PLUGIN_SLUG) ?></p>
                <div class="bw-notice-button-container">
                    <div class="bw-spinner spinner"></div>
                    <button class="button button-primary bw-activation-plugin-modal-btn"><?= __('Activate', BW_PLUGIN_SLUG) ?></button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="bw-modal-overlay" id="bw-upgrade-modal">
    <div class="bw-modal-container">
        <div class="bw-modal-middle">
            <div class="bw-modal-content">
                <div class="bw-logo"></div>
                <div class="bw-modal-close"></div>
                <div class="bw-modal-title bw-black bw-font-size-24"><?= __('🔒Unlock the full potential of Betawall!', BW_PLUGIN_SLUG) ?></div>
                <div class="bw-modal-title bw-black bw-font-size-20 bw-margin-top-10"><?= __('🛡 With the Pro version, you get:', BW_PLUGIN_SLUG) ?></div>
                <div class="bw-modal-text">
                    <table class="bw-features-table">
                        <tr>
                            <td colspan="2"><p class="bw-bold bw-black bw-font-size-18"><?= __('Real-time protection against:', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('DDoS Attacks', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('404 Request Flood', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('Admin Panel Brute Force', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('SQL Injection Attacks', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('Arbitrary Code Execution', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('XSS Attacks', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('RFI Attacks', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">🛡</p></td>
                            <td><p class="bw-font-size-16"><?= __('Suspicious File Uploads', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                    </table>

                    <table class="bw-features-table">
                        <tr>
                            <td colspan="2"><p class="bw-bold bw-black bw-font-size-18"><?= __('More security:', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('Allowed IPs Admin Panel Login', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('2FA', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('Google reCAPTCHA v3', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                    </table>

                    <table class="bw-features-table">
                        <tr>
                            <td colspan="2"><p class="bw-bold bw-black bw-font-size-18"><?= __('Stay Protected and Informed:', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('Automatic threat database updates', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('Threat analytics and reporting', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                        <tr>
                            <td><p class="bw-font-size-16">✅</p></td>
                            <td><p class="bw-font-size-16"><?= __('Priority support and performance enhancements', BW_PLUGIN_SLUG) ?></p></td>
                        </tr>
                    </table>
                </div>
                <p class="bw-modal-short-text"><?= __('Click <b>"Upgrade"</b> to continue or <b>"Restore"</b> if you already have the Pro version', BW_PLUGIN_SLUG) ?></p>
                <div class="bw-notice-button-container">
                    <div class="bw-spinner spinner"></div>
                    <button class="button button-primary button-inline bw-upgrade-plugin-modal-btn-upgrade"><?= __('Upgrade', BW_PLUGIN_SLUG) ?></button>
                    <button class="button button-primary button-primary-green button-inline bw-upgrade-plugin-modal-btn-restore"><?= __('Restore', BW_PLUGIN_SLUG) ?></button>
                </div>
            </div>
        </div>
    </div>
</div>