<?php

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(403);
    exit;
}

$key = $_GET['key'] ?? null;

if (empty($key)) {
    http_response_code(403);
    exit;
}

require_once(__DIR__ . '/../includes/helpers/MainHelper.php');
use betawall\helpers\MainHelper;

if (!MainHelper::checkValidSecretKey($key)) {
    http_response_code(403);
    exit;
}

require_once(__DIR__ . '/../../../../wp-load.php');
require_once(__DIR__ . '/../includes/db/structures/SettingsStructure.php');
require_once(__DIR__ . '/../includes/db/structures/FirewallBlacklistStructure.php');
require_once(__DIR__ . '/../includes/db/structures/FirewallWhitelistStructure.php');
require_once(__DIR__ . '/../includes/db/models/SettingsModel.php');
require_once(__DIR__ . '/../includes/db/models/FirewallBlacklistModel.php');
require_once(__DIR__ . '/../includes/db/models/FirewallWhitelistModel.php');
require_once(__DIR__ . '/../includes/helpers/BinaryHelper.php');

use betawall\db\models\SettingsModel;
use betawall\helpers\BinaryHelper;
use betawall\components\ViewManager;

$settingsModel = new SettingsModel();
$unblockKey = $settingsModel->get_by_name($settingsModel->unblock_key);

if (!$unblockKey || empty($unblockKey->value_text) || $unblockKey->value_text !== $key) {
    http_response_code(403);
    exit;
}

$clientIp = MainHelper::getClientIp();
$binaryHelper = BinaryHelper::getInstance();

if ($binaryHelper->searchInFirewallList($clientIp, true) === false) {
    $binaryHelper->addToFirewallWhitelist($clientIp);
}

$viewManager = new ViewManager();

$viewManager->render('', '_unblock', []);