<?php
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(403);
    echo json_encode(['result' => 'error']);
    exit;
}

$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!is_array($data)) {
    http_response_code(403);
    echo json_encode(['result' => 'error']);
    exit;
}

$secretKeyChecking = $data['secret_key'] ?? null;
if (empty($secretKeyChecking)) {
    http_response_code(403);
    echo json_encode(['result' => 'error']);
    exit;
}

require_once(__DIR__ . '/../includes/helpers/MainHelper.php');
use betawall\helpers\MainHelper;

if (!MainHelper::checkValidSecretKey($secretKeyChecking)) {
    http_response_code(403);
    echo json_encode(['result' => 'error']);
    exit;
}

require_once(__DIR__ . '/../../../../wp-load.php');
require_once(__DIR__ . '/../includes/db/models/SettingsModel.php');
require_once(__DIR__ . '/../includes/helpers/TasksHelper.php');

use betawall\db\models\SettingsModel;
use betawall\helpers\TasksHelper;

$settingsModel = new SettingsModel();
$secretKeyCurrent = $settingsModel->get_by_name($settingsModel->secret_key);

if (!$secretKeyCurrent || empty($secretKeyCurrent->value_text) || $secretKeyCurrent->value_text !== $secretKeyChecking) {
    http_response_code(403);
    echo json_encode(['result' => 'error']);
    exit;
}

$tasksHelper = new TasksHelper();
$result = $tasksHelper->malware_get_update();

if ($result->success) {
    http_response_code(200);
    echo json_encode(['result' => 'successful']);
    exit;
}

http_response_code(400);
echo json_encode(['result' => 'error']);
exit;