<?php

if (!defined('BW_PLUGIN_PATH')) {
    define('BW_PLUGIN_PATH', plugin_dir_path(__FILE__));
}
if (!defined('BW_PLUGIN_URL')) {
    define('BW_PLUGIN_URL', plugin_dir_url(__FILE__));
}

require_once __DIR__ . '/includes/helpers/MainHelper.php';
require_once __DIR__ . '/includes/helpers/FileSystemHelper.php';
require_once __DIR__ . '/includes/helpers/MuHelper.php';
require_once __DIR__ . '/includes/helpers/BinaryHelper.php';
require_once __DIR__ . '/includes/helpers/FirewallHelper.php';
require_once __DIR__ . '/includes/db/DatabaseProvider.php';
require_once __DIR__ . '/includes/db/structures/SettingsStructure.php';
require_once __DIR__ . '/includes/db/structures/MalwareStructure.php';
require_once __DIR__ . '/includes/db/structures/FirewallBlacklistStructure.php';
require_once __DIR__ . '/includes/db/structures/FirewallWhitelistStructure.php';
require_once __DIR__ . '/includes/db/models/SettingsModel.php';
require_once __DIR__ . '/includes/db/models/MalwareModel.php';
require_once __DIR__ . '/includes/db/models/FirewallBlacklistModel.php';
require_once __DIR__ . '/includes/db/models/FirewallWhitelistModel.php';

use betawall\helpers\FirewallHelper;

$firewallHelper = FirewallHelper::getInstance();
add_action('muplugins_loaded', [$firewallHelper, 'track_mu_request']);