<?php
namespace betawall\helpers;

use betawall\db\models\SettingsModel;
use WP_REST_Request;
use WP_REST_Response;
use WP_Error;

class RestApiHelper {

    public function rest_api_verification(WP_REST_Request $request)
    {
        $secretKeyChecking = $request->get_param('secret_key');

        if (empty($secretKeyChecking)) {
            return new WP_Error('Error', 'secret_key is empty', ['result' => 'error', 'status' => 400]);
        }

        if (!MainHelper::checkValidSecretKey($secretKeyChecking)) {
            return new WP_Error('Error', 'Invalid secret_key', ['result' => 'error', 'status' => 400]);
        }

        $settingsModel = new SettingsModel();
        $secretKeyCurrent = $settingsModel->get_by_name($settingsModel->secret_key);

        if (($secretKeyCurrent->value_text ?? '') !== '') {
            if ($secretKeyCurrent->value_text !== $secretKeyChecking) {
                return new WP_Error('Error', 'Incorrect secret_key', ['result' => 'error', 'status' => 400]);
            }
            return new WP_REST_Response(['result' => 'successful', 'message' => 'Website success verified']);
        }

        return new WP_Error('Error', 'secret_key is missing', ['result' => 'error', 'status' => 400]);
    }

    public function rest_authentication($result)
    {
        $settingsModel = new SettingsModel();
        $restApiEnabled = $settingsModel->get_by_name($settingsModel->rest_api_enabled)->value_number ?? SettingsModel::REST_API_ENABLED;

        if ($restApiEnabled == SettingsModel::REST_API_DISABLED) {
            return new WP_Error('rest_disabled', __('REST API disabled.', BW_PLUGIN_SLUG), array('status' => 403));
        }

        return $result;
    }

}