<?php
namespace betawall\helpers;

class MuHelper
{

    const MU_PLUGIN_FILE_PATH = WPMU_PLUGIN_DIR . '/' . 'betawall.php';
    const MU_PLUGIN_FILE_INCLUDE = BW_PLUGIN_PATH . 'mu-betawall.php';

    const MU_PLUGIN_ACTIVATION = 1;
    const MU_PLUGIN_DEACTIVATION = 0;

    public function isEnabledMuPluginMode(): bool
    {
        $wp_filesystem = FileSystemHelper::get_filesystem();
        $muPluginRequirePath = ltrim(str_replace(ABSPATH, '', self::MU_PLUGIN_FILE_INCLUDE), '/');
        $content = "<?php\nrequire_once(ABSPATH . '$muPluginRequirePath');\n";

        if ($wp_filesystem->exists(self::MU_PLUGIN_FILE_PATH)) {
            $currentContent = $wp_filesystem->get_contents(self::MU_PLUGIN_FILE_PATH);
            if ($currentContent == $content) {
                return true;
            }
        }
        return false;
    }

    public function changeMuPluginMode(bool $isEnable): array
    {
        $wp_filesystem = FileSystemHelper::get_filesystem();
        $muPluginRequirePath = ltrim(str_replace(ABSPATH, '', self::MU_PLUGIN_FILE_INCLUDE), '/');
        $content = "<?php\nrequire_once(ABSPATH . '$muPluginRequirePath');\n";

        if ($isEnable) {
            if (!$wp_filesystem->is_dir(WPMU_PLUGIN_DIR) && !@$wp_filesystem->mkdir(WPMU_PLUGIN_DIR, FS_CHMOD_DIR, true)) {
                return ['process' => self::MU_PLUGIN_ACTIVATION, 'result' => false];
            }

            if (!$wp_filesystem->is_writable(WPMU_PLUGIN_DIR)) {
                return ['process' => self::MU_PLUGIN_ACTIVATION, 'result' => false];
            }

            if (!$wp_filesystem->put_contents(self::MU_PLUGIN_FILE_PATH, $content)) {
                return ['process' => self::MU_PLUGIN_ACTIVATION, 'result' => false];
            }

            return ['process' => self::MU_PLUGIN_ACTIVATION, 'result' => true];
        }

        if ($wp_filesystem->exists(self::MU_PLUGIN_FILE_PATH)) {
            if ($wp_filesystem->delete(self::MU_PLUGIN_FILE_PATH)) {
                return ['process' => self::MU_PLUGIN_DEACTIVATION, 'result' => true];
            }
            return ['process' => self::MU_PLUGIN_DEACTIVATION, 'result' => false];
        }

        return ['process' => self::MU_PLUGIN_DEACTIVATION, 'result' => true];
    }

}