<?php
namespace betawall\external;

class PHPGangsta_GoogleAuthenticator
{
    protected $_codeLength = 6;

    public function createSecret( $secretLength = 16 ) {
        $validChars = $this->_getBase32LookupTable();
        $secret     = '';
        for ( $i = 0; $i < $secretLength; $i++ ) {
            $secret .= $validChars[ random_int( 0, 31 ) ];
        }
        return $secret;
    }

    public function getQRCodeGoogleUrl( $name, $secret, $title = null ) {
        $urlencoded = urlencode( 'otpauth://totp/' . $name . '?secret=' . $secret . '&issuer=' . urlencode( $title ) );
        return "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={$urlencoded}";
    }

    public function getCode( $secret, $timeSlice = null ) {
        if ( $timeSlice === null ) {
            $timeSlice = floor( time() / 30 );
        }
        $secretKey = $this->_base32Decode( $secret );
        $time      = chr( 0 ) . chr( 0 ) . chr( 0 ) . chr( 0 ) . pack( 'N*', $timeSlice );
        $hm        = hash_hmac( 'SHA1', $time, $secretKey, true );
        $offset    = ord( substr( $hm, -1 ) ) & 0x0F;
        $hashpart  = substr( $hm, $offset, 4 );
        $value     = unpack( "N", $hashpart );
        $value     = $value[1] & 0x7FFFFFFF;
        $modulo    = pow( 10, $this->_codeLength );
        return str_pad( $value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT );
    }

    public function verifyCode( $secret, $code, $discrepancy = 1, $currentTimeSlice = null ) {
        if ( $currentTimeSlice === null ) {
            $currentTimeSlice = floor( time() / 30 );
        }
        for ( $i = -$discrepancy; $i <= $discrepancy; $i++ ) {
            $calculatedCode = $this->getCode( $secret, $currentTimeSlice + $i );
            if ( $calculatedCode === $code ) {
                return true;
            }
        }
        return false;
    }

    protected function _getBase32LookupTable() {
        return [
            'A','B','C','D','E','F','G','H',
            'I','J','K','L','M','N','O','P',
            'Q','R','S','T','U','V','W','X',
            'Y','Z','2','3','4','5','6','7'
        ];
    }

    protected function _base32Decode( $secret ) {
        if ( empty( $secret ) ) {
            return '';
        }
        $chars   = $this->_getBase32LookupTable();
        $flipped = array_flip( $chars );
        $secret  = str_replace( '=', '', $secret );
        $binaryString = '';
        for ( $i = 0; $i < strlen( $secret ); $i++ ) {
            $val = $flipped[ $secret[$i] ];
            $binaryString .= str_pad( decbin( $val ), 5, '0', STR_PAD_LEFT );
        }
        $eightBits = str_split( $binaryString, 8 );
        $decoded   = '';
        foreach ( $eightBits as $bits ) {
            if ( strlen( $bits ) === 8 ) {
                $decoded .= chr( bindec( $bits ) );
            }
        }
        return $decoded;
    }
}
