<?php
namespace betawall\db\structures;

use betawall\db\DatabaseProvider;

class SettingsStructure extends DatabaseProvider
{

    const TABLE_NAME = "betawall_pro_settings";

    public $id = 'id';
    public $name = 'name';
    public $value_text = 'value_text';
    public $value_number = 'value_number';
    public $created_at = 'created_at';
    public $updated_at = 'updated_at';

    public function __construct()
    {
        parent::__construct(self::TABLE_NAME);
    }

    public function prepare_create_table()
    {
        $sql = "CREATE TABLE IF NOT EXISTS $this->table_name(
            id int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            name varchar(255) NOT NULL,
            value_text text NOT NULL,
            value_number int(11) UNSIGNED NOT NULL,
            created_at int(11) UNSIGNED NOT NULL,
            updated_at int(11) UNSIGNED NOT NULL,
            PRIMARY KEY (id), UNIQUE INDEX idx_name (name)
        ) " . $this->wpdb->get_charset_collate();
        $this->create_table($sql);
    }

    public function delete_table()
    {
        return parent::delete_table();
    }

    public function insert_data($data)
    {
        return parent::insert_data($data);
    }

    public function get_data($where = [], $operator = 'AND', $output_type = OBJECT, $limit = null, $offset = null, $order_rule = null)
    {
        return parent::get_data($where, $operator, $output_type, $limit, $offset, $order_rule);
    }

    public function update_data($data, $where)
    {
        return parent::update_data($data, $where);
    }

    public function update_multiple_with_same_value($column, $value, $where_column, $where_values)
    {
        return parent::update_multiple_with_same_value($column, $value, $where_column, $where_values);
    }

    public function delete_data($where)
    {
        return parent::delete_data($where);
    }

    public function delete_data_multiple_ids(array $ids)
    {
        return parent::delete_data_multiple_ids($ids);
    }

}