<?php
namespace betawall\db\structures;

use betawall\db\DatabaseProvider;

class FirewallBlacklistStructure extends DatabaseProvider
{

    const TABLE_NAME = 'betawall_pro_firewall_blacklist';

    public $id = 'id';

    /**
     * 0 - 404
     * 1 - Unsuccessful login
     * 2 - SQL
     * 3 - Code execution
     * 4 - XSS
     * 5 - RFI
     */
    public $type = 'request_type';

    public $ip = 'ip';
    public $created_at = 'created_at';
    public $updated_at = 'updated_at';

    public function __construct()
    {
        parent::__construct(self::TABLE_NAME);
    }

    public function prepare_create_table()
    {
        $sql = "CREATE TABLE IF NOT EXISTS $this->table_name (
            id int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            request_type tinyint NOT NULL,
            ip varchar(255) NOT NULL UNIQUE,
            created_at int(11) UNSIGNED NOT NULL,
            updated_at int(11) UNSIGNED NOT NULL,
            PRIMARY KEY (id),
            INDEX idx_request_type (request_type)
        ) " . $this->wpdb->get_charset_collate();
        $this->create_table($sql);
    }

    public function delete_table()
    {
        return parent::delete_table();
    }

    public function insert_data($data)
    {
        return parent::insert_data($data);
    }

    public function get_data($where = [], $operator = 'AND', $output_type = OBJECT, $limit = null, $offset = null, $order_rule = null)
    {
        return parent::get_data($where, $operator, $output_type, $limit, $offset, $order_rule);
    }

    public function get_counts($where = [], $operator = 'AND')
    {
        return parent::get_counts($where, $operator);
    }

    public function update_data($data, $where)
    {
        return parent::update_data($data, $where);
    }

    public function delete_data($where)
    {
        return parent::delete_data($where);
    }

    public function delete_data_multiple_ids(array $ids)
    {
        return parent::delete_data_multiple_ids($ids);
    }

}