<?php
namespace betawall\db\models;

use betawall\db\structures\SettingsStructure;

class SettingsModel
{

    public $settings_structure;

    public $secret_key = 'secret_key';

    public $unblock_key = 'unblock_key';

    public $error_states = 'error_states';
    const ERROR_STATE_NO_ERRORS = 0;
    const ERROR_STATE_ERROR_ACTIVATION = 1;
    const ERROR_STATE_WRONG_DOMAIN = 2;
    const ERROR_STATE_NOT_VERIFIED = 3;
    const ERROR_STATE_DEACTIVATED = 4;
    const ERROR_STATE_NEED_ACTIVATION = 5;
    const ERROR_STATE_NEED_ACTIVATION_MODAL = 6;

    public $access_state = 'access_state';
    const ACCESS_STATE_ALLOWED = 0;
    const ACCESS_STATE_DENIED = 1;
    const ACCESS_FEATURE_DENIED = 2;

    public $firewall_notfound_enabled = 'firewall_notfound_enabled';
    public $firewall_notfound_5m_limit = 'firewall_notfound_5m_limit';
    public $firewall_notfound_24h_limit = 'firewall_notfound_24h_limit';
    const FIREWALL_NOTFOUND_ENABLED = 1;
    const FIREWALL_NOTFOUND_DISABLED = 0;
    const FIREWALL_NOTFOUND_5M_LIMIT_DEFAULT = 5;
    const FIREWALL_NOTFOUND_24H_LIMIT_DEFAULT = 10;


    public $firewall_failed_login_enabled = 'firewall_failed_login_enabled';
    public $firewall_failed_login_5m_limit = 'firewall_failed_login_5m_limit';
    public $firewall_failed_login_24h_limit = 'firewall_failed_login_24h_limit';
    const FIREWALL_FAILED_LOGIN_ENABLED = 1;
    const FIREWALL_FAILED_LOGIN_DISABLED = 0;
    const FIREWALL_FAILED_LOGIN_5M_LIMIT_DEFAULT = 5;
    const FIREWALL_FAILED_LOGIN_24H_LIMIT_DEFAULT = 10;


    public $firewall_sql_injection_enabled = 'firewall_sql_injection_enabled';
    public $firewall_sql_injection_5m_limit = 'firewall_sql_injection_5m_limit';
    public $firewall_sql_injection_24h_limit = 'firewall_sql_injection_24h_limit';
    const FIREWALL_SQL_INJECTION_ENABLED = 1;
    const FIREWALL_SQL_INJECTION_DISABLED = 0;
    const FIREWALL_SQL_INJECTION_5M_LIMIT_DEFAULT = 1;
    const FIREWALL_SQL_INJECTION_24H_LIMIT_DEFAULT = 1;


    public $firewall_code_execution_enabled = 'firewall_code_execution_enabled';
    public $firewall_code_execution_5m_limit = 'firewall_code_execution_5m_limit';
    public $firewall_code_execution_24h_limit = 'firewall_code_execution_24h_limit';
    const FIREWALL_CODE_EXECUTION_ENABLED = 1;
    const FIREWALL_CODE_EXECUTION_DISABLED = 0;
    const FIREWALL_CODE_EXECUTION_5M_LIMIT_DEFAULT = 1;
    const FIREWALL_CODE_EXECUTION_24H_LIMIT_DEFAULT = 1;


    public $firewall_xss_enabled = 'firewall_xss_enabled';
    public $firewall_xss_5m_limit = 'firewall_xss_5m_limit';
    public $firewall_xss_24h_limit = 'firewall_xss_24h_limit';
    const FIREWALL_XSS_ENABLED = 1;
    const FIREWALL_XSS_DISABLED = 0;
    const FIREWALL_XSS_5M_LIMIT_DEFAULT = 1;
    const FIREWALL_XSS_24H_LIMIT_DEFAULT = 1;


    public $firewall_rfi_enabled = 'firewall_rfi_enabled';
    public $firewall_rfi_5m_limit = 'firewall_rfi_5m_limit';
    public $firewall_rfi_24h_limit = 'firewall_rfi_24h_limit';
    const FIREWALL_RFI_ENABLED = 1;
    const FIREWALL_RFI_DISABLED = 0;
    const FIREWALL_RFI_5M_LIMIT_DEFAULT = 1;
    const FIREWALL_RFI_24H_LIMIT_DEFAULT = 1;


    public $firewall_rfi_external_urls_enabled = 'firewall_rfi_external_urls_enabled';
    const FIREWALL_RFI_EXTERNAL_URLS_ENABLED = 1;
    const FIREWALL_RFI_EXTERNAL_URLS_DISABLED = 0;


    public $firewall_suspicious_file_uploads_enabled = 'firewall_suspicious_file_uploads_enabled';
    public $firewall_suspicious_file_uploads_5m_limit = 'firewall_suspicious_file_uploads_5m_limit';
    public $firewall_suspicious_file_uploads_24h_limit = 'firewall_suspicious_file_uploads_24h_limit';
    const FIREWALL_SUSPICIOUS_FILE_UPLOADS_ENABLED = 1;
    const FIREWALL_SUSPICIOUS_FILE_UPLOADS_DISABLED = 0;
    const FIREWALL_SUSPICIOUS_FILE_UPLOADS_5M_LIMIT_DEFAULT = 1;
    const FIREWALL_SUSPICIOUS_FILE_UPLOADS_24H_LIMIT_DEFAULT = 1;


    public $rest_api_enabled = 'rest_api_enabled';
    const REST_API_UNKNOWN = 0;
    const REST_API_ENABLED = 1;
    const REST_API_DISABLED = 2;


    public $xml_rpc_enabled = 'xml_rpc_enabled';
    const XML_RPC_UNKNOWN = 0;
    const XML_RPC_ENABLED = 1;
    const XML_RPC_DISABLED = 2;


    public $rss_enabled = 'rss_enabled';
    const RSS_UNKNOWN = 0;
    const RSS_ENABLED = 1;
    const RSS_DISABLED = 2;

    public $general_scan_red_dot = 'general_scan_red_dot';
    const GENERAL_SCAN_RED_DOT_SHOW_INTERVAL = 86400;

    public $allowed_ips_enabled = 'allowed_ips_enabled';
    const ALLOWED_IPS_DISABLED = 0;
    const ALLOWED_IPS_ENABLED = 1;

    //RECAPTCHA BLOCK
    public $recaptcha_enabled = 'recaptcha_enabled';
    const RECAPTCHA_DISABLED = 0;
    const RECAPTCHA_ENABLED = 1;

    public $recaptcha_site_key = 'recaptcha_site_key';
    public $recaptcha_secret_key = 'recaptcha_secret_key';
    //============

    //Multi-user 2FA BLOCK
    public $g2fa_enabled = 'g2fa_enabled';
    const G2FA_DISABLED = 0;
    const G2FA_ENABLED = 1;
    //============

    public function __construct()
    {
        $this->settings_structure = new SettingsStructure();
    }

    public function add($data)
    {
        return $this->settings_structure->insert_data($data);
    }

    public function easyAdd(string $name, string $valueText = '', int $valueNumber = 0) :?int
    {
        $data = [
            $this->settings_structure->name         => $name,
            $this->settings_structure->value_text   => $valueText,
            $this->settings_structure->value_number => $valueNumber,
        ];

        return $this->add($data);
    }

    public function get_by_id($id)
    {
        $results = $this->settings_structure->get_data([
            $this->settings_structure->id => $id
        ]);
        return !empty($results) ? $results[0] : null;
    }

    public function get_by_name($name)
    {
        $results = $this->settings_structure->get_data([
            $this->settings_structure->name => $name
        ]);
        return !empty($results) ? $results[0] : null;
    }

    public function get_all($limit = null)
    {
        return $this->settings_structure->get_data([], 'AND', OBJECT, $limit);
    }

    public function get_firewall_protection_settings_modules()
    {
        return $this->settings_structure->get_data(
            [
                $this->settings_structure->name => [
                    $this->firewall_notfound_enabled,
                    $this->firewall_failed_login_enabled,
                    $this->firewall_sql_injection_enabled,
                    $this->firewall_code_execution_enabled,
                    $this->firewall_xss_enabled,
                    $this->firewall_rfi_enabled,
//                    $this->firewall_rfi_external_urls_enabled,
                    $this->firewall_suspicious_file_uploads_enabled,
                ],
            ]
        );
    }

    public function get_firewall_protection_all_settings()
    {
        return $this->settings_structure->get_data(
            [
                $this->settings_structure->name => [
                    $this->firewall_notfound_enabled,
                    $this->firewall_notfound_5m_limit,
                    $this->firewall_notfound_24h_limit,

                    $this->firewall_failed_login_enabled,
                    $this->firewall_failed_login_5m_limit,
                    $this->firewall_failed_login_24h_limit,

                    $this->firewall_sql_injection_enabled,
                    $this->firewall_sql_injection_5m_limit,
                    $this->firewall_sql_injection_24h_limit,

                    $this->firewall_code_execution_enabled,
                    $this->firewall_code_execution_5m_limit,
                    $this->firewall_code_execution_24h_limit,

                    $this->firewall_xss_enabled,
                    $this->firewall_xss_5m_limit,
                    $this->firewall_xss_24h_limit,

                    $this->firewall_rfi_enabled,
                    $this->firewall_rfi_5m_limit,
                    $this->firewall_rfi_24h_limit,
                    $this->firewall_rfi_external_urls_enabled,

                    $this->firewall_suspicious_file_uploads_enabled,
                    $this->firewall_suspicious_file_uploads_5m_limit,
                    $this->firewall_suspicious_file_uploads_24h_limit,
                ],
            ]
        );
    }

    public function update_by_id($id, $data)
    {
        return $this->settings_structure->update_data($data, [
            $this->settings_structure->id => $id
        ]);
    }

    public function update_by_name($name, $data)
    {
        return $this->settings_structure->update_data($data, [
            $this->settings_structure->name => $name
        ]);
    }

    public function delete_by_id($id)
    {
        return $this->settings_structure->delete_data([
            $this->settings_structure->id => $id
        ]);
    }

    public function delete_by_ids(array $ids)
    {
        return $this->settings_structure->delete_data_multiple_ids($ids);
    }

    public function enable_all_protection_settings()
    {
        return $this->settings_structure->update_multiple_with_same_value(
            $this->settings_structure->value_number, 1,
            $this->settings_structure->name, [
                $this->firewall_notfound_enabled,
                $this->firewall_failed_login_enabled,
                $this->firewall_sql_injection_enabled,
                $this->firewall_code_execution_enabled,
                $this->firewall_xss_enabled,
                $this->firewall_rfi_enabled,
                $this->firewall_suspicious_file_uploads_enabled,
            ]
        );
    }

    public function disable_all_protection_settings()
    {
        return $this->settings_structure->update_multiple_with_same_value(
            $this->settings_structure->value_number, 0,
            $this->settings_structure->name, [
                $this->firewall_notfound_enabled,
                $this->firewall_failed_login_enabled,
                $this->firewall_sql_injection_enabled,
                $this->firewall_code_execution_enabled,
                $this->firewall_xss_enabled,
                $this->firewall_rfi_enabled,
                $this->firewall_rfi_external_urls_enabled,
                $this->firewall_suspicious_file_uploads_enabled,
            ]
        );
    }

    public function enable_protection_settings($settings)
    {
        return $this->settings_structure->update_multiple_with_same_value(
            $this->settings_structure->value_number, 1,
            $this->settings_structure->name, $settings
        );
    }

    public function disable_protection_settings($settings)
    {
        return $this->settings_structure->update_multiple_with_same_value(
            $this->settings_structure->value_number, 0,
            $this->settings_structure->name, $settings
        );
    }

    public function is2faEnabled()
    {
        return (int) ($this->get_by_name($this->g2fa_enabled)->value_number ?? self::G2FA_DISABLED);
    }

    public function isReCaptchaEnabled()
    {
        return (int) ($this->get_by_name($this->recaptcha_enabled)->value_number ?? self::RECAPTCHA_DISABLED);
    }

    public function isAllowedIPsEnabled()
    {
        return (int) ($this->get_by_name($this->allowed_ips_enabled)->value_number ?? self::ALLOWED_IPS_DISABLED);
    }
}
