<?php
namespace betawall\db\models;

use betawall\db\structures\FirewallBlacklistStructure;
use betawall\db\structures\MalwareStructure;

class MalwareModel
{

    public $malware_structure;

    const TYPE_NOT_FOUND = 0;
    const TYPE_LOGIN = 1;
    const TYPE_SQL_INJECTION = 2;
    const TYPE_CODE_EXECUTION = 3;
    const TYPE_XSS = 4;
    const TYPE_RFI = 5;
    const TYPE_SUSPICIOUS_FILE = 6;

    const SEND_PORTION_LIMIT = 100;

    const STATUS_SENT = 1;
    const STATUS_NOT_SENT = 0;

    public function __construct()
    {
        $this->malware_structure = new MalwareStructure();
    }

    public function add($data)
    {
        return $this->malware_structure->insert_data($data);
    }

    public function get_by_id($id)
    {
        $results = $this->malware_structure->get_data([
            $this->malware_structure->id => $id
        ]);
        return !empty($results) ? $results[0] : null;
    }

    public function get_by_ip($ip)
    {
        return $this->malware_structure->get_data([
            $this->malware_structure->ip => $ip
        ]);
    }

    public function get_by_type($type)
    {
        return $this->malware_structure->get_data([
            $this->malware_structure->type => $type
        ]);
    }

    public function get_count_requests_time_range($ip, $requestType, $startTime, $endTime)
    {
        return $this->malware_structure->get_counts([
            $this->malware_structure->ip => $ip,
            $this->malware_structure->type => $requestType,
            'time_range' => [$startTime, $endTime]
        ]);
    }

    public function get_count_requests($ip, $requestType)
    {
        return $this->malware_structure->get_counts([
            $this->malware_structure->ip => $ip,
            $this->malware_structure->type => $requestType,
        ]);
    }

    public function get_all($limit = null)
    {
        return $this->malware_structure->get_data([], 'AND', OBJECT, $limit);
    }

    public function get_all_with_ip_check_in_blacklist($limit = null)
    {
        return $this->malware_structure->get_data_with_other_table_condition(
            $this->malware_structure->ip,
            FirewallBlacklistStructure::TABLE_NAME,
            'ip',
            [
                $this->malware_structure->is_sent => self::STATUS_NOT_SENT
            ],
            'AND',
            OBJECT,
            $limit
        );
    }

    public function update_by_id($id, $data)
    {
        return $this->malware_structure->update_data($data, [
            $this->malware_structure->id => $id
        ]);
    }

    public function delete_by_id($id)
    {
        return $this->malware_structure->delete_data([
            $this->malware_structure->id => $id
        ]);
    }

    public function delete_by_ip($ip)
    {
        return $this->malware_structure->delete_data([
            $this->malware_structure->ip => $ip
        ]);
    }

    public function delete_by_ids(array $ids)
    {
        return $this->malware_structure->delete_data_multiple_ids($ids);
    }

    public function update_is_sent_status(array $ids)
    {
        return $this->malware_structure->update_data_multiple_ids($this->malware_structure->is_sent, self::STATUS_SENT, $ids);
    }

    public function delete_by_conditions($conditions, $limit = null)
    {
        return $this->malware_structure->delete_data_limit($conditions, $limit);
    }

}