<?php
namespace betawall\db\models;


use betawall\db\structures\FirewallWhitelistStructure;

class FirewallWhitelistModel
{
    public $firewall_whitelist_structure;

    public function __construct()
    {
        $this->firewall_whitelist_structure = new FirewallWhiteListStructure();
    }

    public function add($data)
    {
        return $this->firewall_whitelist_structure->insert_data($data);
    }

    public function get_by_id($id)
    {
        $results = $this->firewall_whitelist_structure->get_data([
            $this->firewall_whitelist_structure->id => $id
        ]);
        return !empty($results) ? $results[0] : null;
    }

    public function get_by_ip($ip)
    {
        return $this->firewall_whitelist_structure->get_data([
            $this->firewall_whitelist_structure->ip => $ip
        ]);
    }

    public function get_all($limit = null)
    {
        return $this->firewall_whitelist_structure->get_data([], 'AND', OBJECT, $limit);
    }

    public function update_by_id($id, $data)
    {
        return $this->firewall_whitelist_structure->update_data($data, [
            $this->firewall_whitelist_structure->id => $id
        ]);
    }

    public function delete_by_id($id)
    {
        return $this->firewall_whitelist_structure->delete_data([
            $this->firewall_whitelist_structure->id => $id
        ]);
    }

    public function delete_by_ip($ip)
    {
        return $this->firewall_whitelist_structure->delete_data([
            $this->firewall_whitelist_structure->ip => $ip
        ]);
    }

    public function delete_by_ids(array $ids)
    {
        return $this->firewall_whitelist_structure->delete_data_multiple_ids($ids);
    }

    public function get_total_count()
    {
        return $this->firewall_whitelist_structure->get_counts();
    }

    public function get_crud_table_data($output_type, $limit, $offset, $order_rule)
    {
        return $this->firewall_whitelist_structure->get_data([], 'AND', $output_type, $limit, $offset, $order_rule);
    }

}