<?php
namespace betawall\db\models;

use betawall\db\structures\FirewallBlacklistStructure;

class FirewallBlacklistModel
{
    public $firewall_blacklist_structure;

    public function __construct()
    {
        $this->firewall_blacklist_structure = new FirewallBlacklistStructure();
    }

    public function add($data)
    {
        return $this->firewall_blacklist_structure->insert_data($data);
    }

    public function get_by_id($id)
    {
        $results = $this->firewall_blacklist_structure->get_data([
            $this->firewall_blacklist_structure->id => $id
        ]);
        return !empty($results) ? $results[0] : null;
    }

    public function get_by_ip($ip)
    {
        return $this->firewall_blacklist_structure->get_data([
            $this->firewall_blacklist_structure->ip => $ip
        ]);
    }

    public function get_by_type($type)
    {
        return $this->firewall_blacklist_structure->get_data([
            $this->firewall_blacklist_structure->type => $type
        ]);
    }

    public function get_data_blacklist_time_range($startTime, $endTime)
    {
        return $this->firewall_blacklist_structure->get_data([
            'time_range' => [$startTime, $endTime]
        ]);
    }

    public function get_all($limit = null)
    {
        return $this->firewall_blacklist_structure->get_data([], 'AND', OBJECT, $limit);
    }

    public function update_by_id($id, $data)
    {
        return $this->firewall_blacklist_structure->update_data($data, [
            $this->firewall_blacklist_structure->id => $id
        ]);
    }

    public function delete_by_id($id)
    {
        return $this->firewall_blacklist_structure->delete_data([
            $this->firewall_blacklist_structure->id => $id
        ]);
    }

    public function delete_by_ip($ip)
    {
        return $this->firewall_blacklist_structure->delete_data([
            $this->firewall_blacklist_structure->ip => $ip
        ]);
    }

    public function delete_by_ids(array $ids)
    {
        return $this->firewall_blacklist_structure->delete_data_multiple_ids($ids);
    }

    public function get_total_count()
    {
        return $this->firewall_blacklist_structure->get_counts();
    }

    public function get_crud_table_data($output_type, $limit, $offset, $order_rule, $filter_request_type_rule, $filter_date_range_rule, $blacklist_search)
    {
        $where = [];

        if ($filter_request_type_rule !== null) {
            $where[$this->firewall_blacklist_structure->type] = $filter_request_type_rule;
        }

        if ($filter_date_range_rule !== null) {
            $where['time_range'] = $filter_date_range_rule;
        }

        if ($blacklist_search !== null) {
            $where['like'] = [$this->firewall_blacklist_structure->ip, $blacklist_search];
        }

        return $this->firewall_blacklist_structure->get_data(
            $where, 'AND', $output_type, $limit, $offset, $order_rule
        );
    }

    public function get_crud_table_count($filter_request_type_rule, $filter_date_range_rule, $blacklist_search)
    {
        $where = [];

        if ($filter_request_type_rule !== null) {
            $where[$this->firewall_blacklist_structure->type] = $filter_request_type_rule;
        }

        if ($filter_date_range_rule !== null) {
            $where['time_range'] = $filter_date_range_rule;
        }

        if ($blacklist_search !== null) {
            $where['like'] = [$this->firewall_blacklist_structure->ip, $blacklist_search];
        }

        return $this->firewall_blacklist_structure->get_counts($where);
    }

    public function get_count_time_range($startTime, $endTime)
    {
        return $this->firewall_blacklist_structure->get_counts([
            'time_range' => [$startTime, $endTime]
        ]);
    }

}