<?php
namespace betawall\db\models;

use betawall\db\structures\ClearStructure;

class ClearModel
{
    public $clear_structure;

    public function __construct()
    {
        $this->clear_structure = new ClearStructure();
    }

    public function get_custom_data_from_tables(string $table_name, array $join_tables = [], array $join_by = [], array $where = [], string $operator = 'AND', array $fields = [], string $having = '') :array
    {
        return $this->clear_structure->get_custom_data_from_tables($table_name, $join_tables, $join_by, $where, $operator, $fields, $having);
    }

    public function get_custom_data_from_tables_clear(string $sql) :array
    {
        return $this->clear_structure->get_custom_data_from_tables_clear($sql);
    }

    public function delete_custom_data_multiple_ids(string $table, string $field, array $ids, array $where = []) :int
    {
        return $this->clear_structure->delete_custom_data_multiple_ids($table, $field, $ids, $where);
    }

    public function insert_into_custom_table(string $table, array $fields) :int
    {
        return $this->clear_structure->insert_into_custom_table($table, $fields);
    }
}
