<?php
namespace betawall\crud;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

use betawall\db\models\FirewallWhitelistModel;
use WP_List_Table;

class FirewallWhitelistTableData extends WP_List_Table
{

    use CustomPaginationTrait;
    protected $pagination_param = 'whitelist_paged';

    const PER_PAGE = 20;

    public function __construct()
    {
        parent::__construct([
            'singular' => 'item',
            'plural' => 'items',
            'ajax' => false,
        ]);
    }

    public function get_columns()
    {
        return [
            'ip' => __('IP Address', BW_PLUGIN_SLUG),
            'created_at' => __('Added', BW_PLUGIN_SLUG),
            'actions' => __('Actions', BW_PLUGIN_SLUG),
        ];
    }

    public function get_sortable_columns()
    {
        return [
            'created_at' => ['whitelist_created_at', false],
        ];
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name];
    }

    protected function column_ip($item)
    {
        return sprintf(
            '<span class="bw-table-data-ip">%s</span>',
            esc_html($item['ip'])
        );
    }

    protected function column_created_at($item)
    {
        return date('Y-m-d H:i:s', $item['created_at']);
    }

    protected function column_actions($item)
    {
        $buttons = '
            <a href="#" class="button bw-firewall-whitelist-delete-item" data-id="%s">%s</a> 
        ';
        return sprintf(
            $buttons,
            $item['id'],
            esc_html(__('Delete', BW_PLUGIN_SLUG))
        );
    }

    public function display_tablenav($which)
    {
        if ($which === 'bottom') {
            parent::display_tablenav($which);
        }
    }

    public function prepare_items()
    {
        $order_by = isset($_GET['orderby']) ? sanitize_text_field($_GET['orderby']) : null;
        $order = isset($_GET['order']) && strtolower($_GET['order']) === 'asc' ? 'ASC' : 'DESC';

        $this->_column_headers = [$this->get_columns(), [], $this->get_sortable_columns()];

        $order_rule = ['column' => 'created_at', 'direction' => 'DESC'];
        if (!empty($order_by) && $order_by === 'whitelist_created_at') {
            $order_rule['direction'] = $order;
        }

        $firewallWhitelistModel = new FirewallWhitelistModel();
        $totalCountWhitelist = $firewallWhitelistModel->get_total_count();

        $currentPage = $this->get_pagenum();

        $totalPages = (int) ceil($totalCountWhitelist / self::PER_PAGE);
        if ($currentPage > $totalPages) {
            $currentPage = $totalPages;
        }

        $offset = ($currentPage - 1) * self::PER_PAGE;
        if ($offset < 0) {
            $offset = 0;
        }

        $dataWhitelist = $firewallWhitelistModel->get_crud_table_data(
            ARRAY_A, self::PER_PAGE, $offset, $order_rule
        );
        $this->items = !empty($dataWhitelist) ? $dataWhitelist : [];

        $this->set_pagination_args([
            'total_items' => $totalCountWhitelist,
            'per_page' => self::PER_PAGE,
        ]);
    }

}
