<?php
namespace betawall\crud;

trait CustomPaginationTrait {

    /**
     * Gets the current page number.
     *
     * @since 3.1.0
     *
     * @return int
     */
    public function get_pagenum() {
        $pagenum = isset( $_REQUEST[$this->pagination_param] ) ? absint( $_REQUEST[$this->pagination_param] ) : 0;

        if ( isset( $this->_pagination_args['total_pages'] ) && $pagenum > $this->_pagination_args['total_pages'] ) {
            $pagenum = $this->_pagination_args['total_pages'];
        }

        return max( 1, $pagenum );
    }

    /**
     * Displays the pagination.
     *
     * @since 3.1.0
     *
     * @param string $which The location of the pagination: Either 'top' or 'bottom'.
     */
    protected function pagination( $which ) {
        if ( empty( $this->_pagination_args ) ) {
            return;
        }

        $total_items     = $this->_pagination_args['total_items'];
        $total_pages     = $this->_pagination_args['total_pages'];
        $infinite_scroll = false;
        if ( isset( $this->_pagination_args['infinite_scroll'] ) ) {
            $infinite_scroll = $this->_pagination_args['infinite_scroll'];
        }

        if ( 'top' === $which && $total_pages > 1 ) {
            $this->screen->render_screen_reader_content( 'heading_pagination' );
        }

        $output = '<span class="displaying-num">' . sprintf(
            /* translators: %s: Number of items. */
                _n( '%s item', '%s items', $total_items ),
                number_format_i18n( $total_items )
            ) . '</span>';

        $current              = $this->get_pagenum();
        $removable_query_args = wp_removable_query_args();

        $current_url = set_url_scheme( 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] );

        $current_url = remove_query_arg( $removable_query_args, $current_url );

        $page_links = array();

        $total_pages_before = '<span class="paging-input">';
        $total_pages_after  = '</span></span>';

        $disable_first = false;
        $disable_last  = false;
        $disable_prev  = false;
        $disable_next  = false;

        if ( 1 === $current ) {
            $disable_first = true;
            $disable_prev  = true;
        }
        if ( $total_pages === $current ) {
            $disable_last = true;
            $disable_next = true;
        }

        if ( $disable_first ) {
            $page_links[] = '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">&laquo;</span>';
        } else {
            $page_links[] = sprintf(
                "<a class='first-page button' href='%s'>" .
                "<span class='screen-reader-text'>%s</span>" .
                "<span aria-hidden='true'>%s</span>" .
                '</a>',
                esc_url( remove_query_arg( $this->pagination_param, $current_url ) ),
                /* translators: Hidden accessibility text. */
                __( 'First page' ),
                '&laquo;'
            );
        }

        if ( $disable_prev ) {
            $page_links[] = '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">&lsaquo;</span>';
        } else {
            $page_links[] = sprintf(
                "<a class='prev-page button' href='%s'>" .
                "<span class='screen-reader-text'>%s</span>" .
                "<span aria-hidden='true'>%s</span>" .
                '</a>',
                esc_url( add_query_arg( $this->pagination_param, max( 1, $current - 1 ), $current_url ) ),
                /* translators: Hidden accessibility text. */
                __( 'Previous page' ),
                '&lsaquo;'
            );
        }

        if ( 'bottom' === $which ) {
            $html_current_page  = $current;
            $total_pages_before = sprintf(
                '<span class="screen-reader-text">%s</span>' .
                '<span id="table-paging" class="paging-input">' .
                '<span class="tablenav-paging-text">',
                /* translators: Hidden accessibility text. */
                __( 'Current Page' )
            );
        } else {
            $html_current_page = sprintf(
                '<label for="current-page-selector" class="screen-reader-text">%s</label>' .
                "<input class='current-page' id='current-page-selector' type='text'
					name='$this->pagination_param' value='%s' size='%d' aria-describedby='table-paging' />" .
                "<span class='tablenav-paging-text'>",
                /* translators: Hidden accessibility text. */
                __( 'Current Page' ),
                $current,
                strlen( $total_pages )
            );
        }

        $html_total_pages = sprintf( "<span class='total-pages'>%s</span>", number_format_i18n( $total_pages ) );

        $page_links[] = $total_pages_before . sprintf(
            /* translators: 1: Current page, 2: Total pages. */
                _x( '%1$s of %2$s', 'paging' ),
                $html_current_page,
                $html_total_pages
            ) . $total_pages_after;

        if ( $disable_next ) {
            $page_links[] = '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">&rsaquo;</span>';
        } else {
            $page_links[] = sprintf(
                "<a class='next-page button' href='%s'>" .
                "<span class='screen-reader-text'>%s</span>" .
                "<span aria-hidden='true'>%s</span>" .
                '</a>',
                esc_url( add_query_arg( $this->pagination_param, min( $total_pages, $current + 1 ), $current_url ) ),
                /* translators: Hidden accessibility text. */
                __( 'Next page' ),
                '&rsaquo;'
            );
        }

        if ( $disable_last ) {
            $page_links[] = '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">&raquo;</span>';
        } else {
            $page_links[] = sprintf(
                "<a class='last-page button' href='%s'>" .
                "<span class='screen-reader-text'>%s</span>" .
                "<span aria-hidden='true'>%s</span>" .
                '</a>',
                esc_url( add_query_arg( $this->pagination_param, $total_pages, $current_url ) ),
                /* translators: Hidden accessibility text. */
                __( 'Last page' ),
                '&raquo;'
            );
        }

        $pagination_links_class = 'pagination-links';
        if ( ! empty( $infinite_scroll ) ) {
            $pagination_links_class .= ' hide-if-js';
        }
        $output .= "\n<span class='$pagination_links_class'>" . implode( "\n", $page_links ) . '</span>';

        if ( $total_pages ) {
            $page_class = $total_pages < 2 ? ' one-page' : '';
        } else {
            $page_class = ' no-pages';
        }
        $this->_pagination = "<div class='tablenav-pages{$page_class}'>$output</div>";

        echo $this->_pagination;
    }

}