<?php
namespace betawall\controllers;

use betawall\components\NavManager;
use betawall\components\ViewManager;
use betawall\db\models\FirewallBlacklistModel;
use betawall\db\models\MalwareModel;
use betawall\db\models\SettingsModel;
use betawall\helpers\BinaryHelper;
use betawall\helpers\FirewallHelper;
use betawall\helpers\InitHelper;
use betawall\helpers\MainHelper;
use betawall\helpers\TasksHelper;

class HomeController
{

    const VIEWS_DIR_NAME = 'home';

    public function index()
    {
        $notFoundAttacks30dCount = 0;
        $adminPanelAttacks30dCount = 0;
        $sqlAttacks30dCount = 0;
        $codeExecutionAttacks30dCount = 0;
        $xssAttacks30dCount = 0;
        $rfiAttacks30dCount = 0;
        $suspiciousFilesAttacks30dCount = 0;
        $allAttacks30dCount = 0;

        $firewallBlacklistModel = new FirewallBlacklistModel();
        $last24hBlockedItems = $firewallBlacklistModel->get_data_blacklist_time_range(
            current_time('timestamp') - FirewallHelper::THIRTY_DAYS,
            current_time('timestamp')
        );

        if (!empty($last24hBlockedItems)) {
            foreach ($last24hBlockedItems as $item) {
                switch ($item->request_type) {
                    case MalwareModel::TYPE_NOT_FOUND:
                        $notFoundAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_LOGIN:
                        $adminPanelAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_SQL_INJECTION:
                        $sqlAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_CODE_EXECUTION:
                        $codeExecutionAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_XSS:
                        $xssAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_RFI:
                        $rfiAttacks30dCount++;
                    break;
                    case MalwareModel::TYPE_SUSPICIOUS_FILE:
                        $suspiciousFilesAttacks30dCount++;
                    break;
                }
                $allAttacks30dCount++;
            }
        }

        $navManager = new NavManager();
        $viewManager = new ViewManager();
        $viewManager->render(self::VIEWS_DIR_NAME, '_index', [
            'notfound_attacks_30d_count' => $notFoundAttacks30dCount,
            'admin_panel_attacks_30d_count' => $adminPanelAttacks30dCount,
            'sql_attacks_30d_count' => $sqlAttacks30dCount,
            'code_execution_attacks_30d_count' => $codeExecutionAttacks30dCount,
            'xss_attacks_30d_count' => $xssAttacks30dCount,
            'rfi_attacks_30d_count' => $rfiAttacks30dCount,
            'suspicious_files_attacks_30d_count' => $suspiciousFilesAttacks30dCount,
            'all_attacks_30d_count' => $allAttacks30dCount,
            'nav_manager' => $navManager,
        ]);
    }

    /**
     * AJAX action
     */
    public function activation()
    {
        if (!MainHelper::checkForAjaxRequestAccess()) {
            wp_die(BW_PLUGIN_NAME . " - " . __('incorrect request', BW_PLUGIN_SLUG));
        }

        $initHelper = new InitHelper();
        $initHelper->activationProcess();
		
		$navManager = new NavManager();

        wp_send_json([
			'result' => 'successful',
			'redirect_url' => $navManager->generate_url('general_scan', 'index')
		]);
    }

    /**
     * AJAX action
     */
    public function upgrade()
    {
        if (!MainHelper::checkForAjaxRequestAccess()) {
            wp_die(BW_PLUGIN_NAME . " - " . __('incorrect request', BW_PLUGIN_SLUG));
        }

        $isRestore = isset($_POST['is_restore']) && $_POST['is_restore'] === 'true';

        $needActivationStates = [
            SettingsModel::ERROR_STATE_NEED_ACTIVATION,
            SettingsModel::ERROR_STATE_NEED_ACTIVATION_MODAL
        ];

        $initHelper = new InitHelper();
        $settingsModel = new SettingsModel();

        $errorObj = $settingsModel->get_by_name($settingsModel->error_states);
        $globalErrorState = $errorObj->value_number ?? SettingsModel::ERROR_STATE_NO_ERRORS;

        $successResponse = ['result' => 'successful'];
        $errorResponse = [
            'result' => 'error',
            'message' => __('Could not restore the Pro version of Betawall for your site.', BW_PLUGIN_SLUG)
        ];

        if (in_array($globalErrorState, $needActivationStates)) {
            $activationSuccess = $initHelper->activationProcess();
            if (!$isRestore || $activationSuccess) {
                wp_send_json($successResponse);
            }

            wp_send_json($errorResponse);
        }

        if (!$isRestore) {
            wp_send_json($successResponse);
        }

        $tasksHelper = new TasksHelper();
        $result = $tasksHelper->malware_get_update();
        if ($result->success && $result->s == BinaryHelper::S1) {
            wp_send_json($successResponse);
        }

        wp_send_json($errorResponse);
    }

}