<?php
namespace betawall\components;

use betawall\db\models\SettingsModel;
use betawall\helpers\MainHelper;

class Router
{

    private function allowedControllers()
    {
        return [
            'FirewallController',
            'GeneralScanController',
            'HomeController',
        ];
    }

    /**
     * Handle the routing of the request.
     */
    public function route()
    {
        $isPluginPage = MainHelper::user_can_affect_site() && isset($_GET['page']) && $_GET['page'] === BW_PLUGIN_SLUG;
        $isAjaxRequest = MainHelper::user_can_affect_site() && defined('DOING_AJAX') && DOING_AJAX;

        if (!$isPluginPage && !$isAjaxRequest) {
            return;
        }

        $currentControllerName = $isAjaxRequest
            ? (isset($_REQUEST['c']) ? sanitize_text_field($_REQUEST['c']) : 'home')
            : (isset($_GET['c']) ? sanitize_text_field($_GET['c']) : 'home');

        $currentActionName = $isAjaxRequest
            ? (isset($_REQUEST['a']) ? sanitize_text_field($_REQUEST['a']) : 'index')
            : (isset($_GET['a']) ? sanitize_text_field($_GET['a']) : 'index');

        $allowedController = str_replace(' ', '', ucwords(str_replace('_', ' ', $currentControllerName))) . 'Controller';

        if (in_array($allowedController, $this->allowedControllers())) {
            $controllerClass = "betawall\\controllers\\" . $allowedController;
            if (class_exists($controllerClass)) {
                $controller = new $controllerClass();
                if (method_exists($controller, $currentActionName)) {
                    $controller->$currentActionName();
                } else {
                    wp_die(BW_PLUGIN_NAME . " - incorrect request");
                }
            } else {
                wp_die(BW_PLUGIN_NAME . " - incorrect request");
            }
        } else {
            wp_die(BW_PLUGIN_NAME . " - incorrect request");
        }
    }

    public function routeGuest()
    {
        $publicAllowed = [
            'firewall' => ['save_recapthca_settings', 'save_g2fa_changes', 'change_allowed_ips_status'],
        ];

        $controller = isset($_REQUEST['c']) ? sanitize_text_field($_REQUEST['c']) : '';
        $action = isset($_REQUEST['a']) ? sanitize_text_field($_REQUEST['a']) : '';
        $unblockKey = isset($_REQUEST['unblock_key']) ? sanitize_text_field($_REQUEST['unblock_key']) : '';

        if (!isset($publicAllowed[$controller]) || !in_array($action, $publicAllowed[$controller], true)) {
            wp_die(BW_PLUGIN_NAME . " - incorrect request");
        }

        if (!MainHelper::checkValidSecretKey($unblockKey)) {
            wp_die(BW_PLUGIN_NAME . " - incorrect request");
        }

        if (!$this->isValidSecretKey($unblockKey)) {
            wp_die(BW_PLUGIN_NAME . " - incorrect request");
        }

        $allowedController = str_replace(' ', '', ucwords(str_replace('_', ' ', $controller))) . 'Controller';
        $controllerClass = "betawall\\controllers\\" . $allowedController;

        if (class_exists($controllerClass)) {
            $controllerObj = new $controllerClass();
            if (method_exists($controllerObj, $action)) {
                $controllerObj->$action();

                return;
            }
        }

        wp_die(BW_PLUGIN_NAME . " - incorrect request");
    }

    private function isValidSecretKey($unblockKey)
    {
        $settingsModel = new SettingsModel();
        $unblockKeyCurrent = $settingsModel->get_by_name($settingsModel->unblock_key);

        if ($unblockKeyCurrent && $unblockKeyCurrentValue = $unblockKeyCurrent->value_text) {
            return $unblockKeyCurrentValue === $unblockKey;
        }

        return false;
    }
}
