<?php
namespace betawall\components;

class NavManager
{

    /**
     * Generate URL for a specific controller and action.
     *
     * @param string $controller The name of the controller.
     * @param string $action The name of the action.
     * @param array $params Additional parameters to include in the URL.
     * @return string The generated URL.
     */
    public function generate_url($controller, $action, $params = [])
    {
        $url = add_query_arg(
            [
                'page' => BW_PLUGIN_SLUG,
                'c' => $controller,
                'a' => $action
            ],
            home_url('/wp-admin/admin.php')
        );

        if (!empty($params)) {
            $url = add_query_arg($params, $url);
        }

        return $url;
    }

    /**
     * Redirect to a specific controller and action.
     *
     * @param string $controller The name of the controller.
     * @param string $action The name of the action.
     * @param array $params Additional parameters to include in the URL.
     */
    public function redirect($controller, $action, $params = [])
    {
        $url = $this->generate_url($controller, $action, $params);

        $redirect = '<script type="text/javascript">';
        $redirect .= 'window.location.href="' . $url . '";';
        $redirect .= '</script>';

        echo $redirect;

        exit;
    }

}