<?php
namespace betawall\api\requests;

use betawall\api\ApiClient;
use betawall\api\data\MalwareSendResponseData;

class MalwareSendRequest
{

    const ENDPOINT = '/malware/send';
    private $api_client;
    public $request_data;

    public function __construct($requestData, $apiKey)
    {
        $this->api_client = new ApiClient($apiKey);
        $this->request_data = $requestData;
    }

    public function sendRequest()
    {
        $response = $this->api_client->post(self::ENDPOINT, $this->request_data);
        return $this->getResponse($response);
    }

    private function getResponse($response)
    {
        if (is_wp_error($response)) {
            return new MalwareSendResponseData(false, $response->get_error_message(), [], []);
        }
        if (json_last_error() !== JSON_ERROR_NONE) {
            return new MalwareSendResponseData(false, 'Error decoding JSON response: ' . json_last_error_msg(), [], []);
        }

        $body = wp_remote_retrieve_body($response);
        $decodedBody = json_decode($body, true);

        if (!isset($decodedBody['success'], $decodedBody['message'], $decodedBody['data'], $decodedBody['errors'])) {
            return new MalwareSendResponseData(false, 'Invalid response format.', [], []);
        }

        return new MalwareSendResponseData($decodedBody['success'], $decodedBody['message'], $decodedBody['data'], $decodedBody['errors']);
    }

}
