<?php
namespace betawall\api\requests;

use betawall\api\ApiClient;
use betawall\api\data\ActivationResponseData;

class ActivationRequest
{

    const ENDPOINT = '/site/activation';
    private $api_client;
    public $request_data;

    public function __construct($requestData)
    {
        $this->api_client = new ApiClient();
        $this->request_data = $requestData;
    }

    public function sendRequest()
    {
        $response = $this->api_client->post(self::ENDPOINT, $this->request_data);
        return $this->getResponse($response);
    }

    private function getResponse($response)
    {
        if (is_wp_error($response)) {
            return new ActivationResponseData(false, $response->get_error_message(), [], []);
        }
        if (json_last_error() !== JSON_ERROR_NONE) {
            return new ActivationResponseData(false, 'Error decoding JSON response: ' . json_last_error_msg(), [], []);
        }

        $body = wp_remote_retrieve_body($response);
        $decodedBody = json_decode($body, true);
        if (!isset($decodedBody['success'], $decodedBody['message'], $decodedBody['data'], $decodedBody['errors'])) {
            return new ActivationResponseData(false, 'Invalid response format.', [], []);
        }

        return new ActivationResponseData($decodedBody['success'], $decodedBody['message'], $decodedBody['data'], $decodedBody['errors']);
    }

}
