<?php
namespace betawall\api\data;

class MalwareGetUpdateResponseData
{

    public $success;
    public $message;
    public $data;
    public $errors;

    //data
    public $db_link;
    public $deactivated;
    public $unverified;
    public $request_problems;
    public $s;

    public function __construct($success, $message, $data = [], $errors = [])
    {
        $this->success = $success;
        $this->message = $message;
        $this->data = $data;
        $this->errors = $errors;

        $this->parseResponseData();
    }

    private function parseResponseData()
    {
        if (!empty($this->data) && is_array($this->data)) {
            if (isset($this->data['db_link'])) {
                $this->db_link = $this->data['db_link'];
            }
            if (isset($this->data['deactivated'])) {
                $this->deactivated = $this->data['deactivated'];
            }
            if (isset($this->data['unverified'])) {
                $this->unverified = $this->data['unverified'];
            }
            if (isset($this->data['request_problems'])) {
                $this->request_problems = $this->data['request_problems'];
            }
            if (isset($this->data['s'])) {
                $this->s = $this->data['s'];
            }
        }
    }

}