<?php
namespace betawall\api;

class ApiClient
{

    const API_URL = 'https://api.betawall.pro/v1';
    private $api_key;

    public function __construct($apiKey = null)
    {
        $this->api_key = $apiKey;
    }

    private function getHeadersAuthentification()
    {
        return [
            'X-Api-Key' => $this->api_key,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        ];
    }

    private function getHeadersStandard()
    {
        return [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        ];
    }

    public function get($endpoint, $params = [])
    {
        $url = add_query_arg(get_object_vars($params), self::API_URL . $endpoint);
        return wp_remote_get($url, [
            'headers' => $this->api_key ?
                $this->getHeadersAuthentification() :
                $this->getHeadersStandard(),
        ]);
    }

    public function post($endpoint, $data = [])
    {
        $url = self::API_URL . $endpoint;
        return wp_remote_post($url, [
            'headers' => $this->api_key ?
                $this->getHeadersAuthentification() :
                $this->getHeadersStandard(),
            'body' => json_encode($data),
        ]);
    }

    public static function getErrorMessages($response)
    {
        $errorMessages = [];
        if (is_array($response->errors)) {
            if (array_keys($response->errors) !== range(0, count($response->errors) - 1)) {
                foreach ($response->errors as $field => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $msg) {
                            $errorMessages[] = "{$field}: {$msg}";
                        }
                    }
                }
            } else {
                foreach ($response->errors as $msg) {
                    $errorMessages[] = $msg;
                }
            }
        }
        return $errorMessages;
    }

}